/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.spin.util.api.ExtendedInstallationAPIProvider;
import com.spin.util.math.PoseMath;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;

public class BitChangingStation {
    private static final double bitXOffsetMM = 35.5;
    private static final double bitYOffsetMM = 19.5;
    private static final double bitZOffsetMM = 7.5;
    private static final double inFrontOfBitYOffset = -10.0;
    static final double endSafeYOffset = 5.0;
    @NotNull
    private final UUID id;
    @NotNull
    private final String name;
    @NotNull
    private final Pose referencePose;
    @NotNull
    private final PoseFactory poseFactory;
    @NotNull
    private final PoseMath.Transformation transformationFromReferenceFrameToBaseFrame;

    public BitChangingStation(@NotNull UUID id, @NotNull String name, @NotNull Pose referencePose, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.id = id;
        this.name = name;
        this.referencePose = referencePose;
        this.poseFactory = apiProvider.getInstallationAPIProvider().getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.transformationFromReferenceFrameToBaseFrame = apiProvider.getPoseMath().makeTransformationToBaseFrame(referencePose);
    }

    @NotNull
    public static Pose calculateReferencePose(@NotNull Position position1, @NotNull Position position2, @NotNull Position position3, @NotNull ValueFactoryProvider valueFactoryProvider) throws InvalidTeachPoints {
        PoseMath poseMath = new PoseMath(valueFactoryProvider);
        TeachPoints teachPoints = TeachPoints.createAndVerifyFromUnorderedPositions(position1, position2, position3);
        Vector3D referencePosition = BitChangingStation.calculateReferencePosition(teachPoints);
        Rotation referenceRotation = BitChangingStation.calculateReferenceRotation(teachPoints);
        return poseMath.asURPose(referencePosition, referenceRotation);
    }

    @NotNull
    private static Vector3D calculateReferencePosition(@NotNull TeachPoints teachPoints) {
        return new Vector3D(0.5, teachPoints.pointB, 0.5, teachPoints.pointC);
    }

    @NotNull
    private static Rotation calculateReferenceRotation(@NotNull TeachPoints teachPoints) {
        Vector3D directionBA = teachPoints.pointA.subtract((Vector)teachPoints.pointB).normalize();
        Vector3D directionBC = teachPoints.pointC.subtract((Vector)teachPoints.pointB).normalize();
        Vector3D directionUp = Vector3D.crossProduct((Vector3D)directionBC, (Vector3D)directionBA).normalize();
        return new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_K, directionBC, directionUp);
    }

    @NotNull
    public UUID id() {
        return this.id;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public Pose referencePose() {
        return this.referencePose;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public Pose poseOf(@NotNull Bit bit) {
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(this.relativePoseOf(bit));
    }

    @NotNull
    public Pose poseInFrontOf(@NotNull Bit bit) {
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(this.relativePoseInFrontOf(bit));
    }

    @NotNull
    public Pose poseEndSafe(@NotNull Bit bit) {
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(this.relativePoseEndSafeOf(bit));
    }

    @NotNull
    public Pose poseOfPointB() {
        Pose relativePoseOfPointB = this.poseFactory.createPose(-65.0, 0.0, 0.0, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(relativePoseOfPointB);
    }

    @NotNull
    public Pose poseAbovePointB() {
        Pose relativePoseAbovePointB = this.poseFactory.createPose(-65.0, 0.0, 70.0, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(relativePoseAbovePointB);
    }

    @NotNull
    private Pose relativePoseOf(@NotNull Bit bit) {
        switch (bit) {
            case BIT_1: {
                return this.poseFactory.createPose(-35.5, 19.5, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_2: {
                return this.poseFactory.createPose(0.0, 19.5, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_3: {
                return this.poseFactory.createPose(35.5, 19.5, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
        }
        throw new IllegalArgumentException("Unsupported bit");
    }

    @NotNull
    private Pose relativePoseInFrontOf(@NotNull Bit bit) {
        switch (bit) {
            case BIT_1: {
                return this.poseFactory.createPose(-35.5, -10.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_2: {
                return this.poseFactory.createPose(0.0, -10.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_3: {
                return this.poseFactory.createPose(35.5, -10.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
        }
        throw new IllegalArgumentException("Unsupported bit");
    }

    @NotNull
    private Pose relativePoseEndSafeOf(@NotNull Bit bit) {
        switch (bit) {
            case BIT_1: {
                return this.poseFactory.createPose(-35.5, 5.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_2: {
                return this.poseFactory.createPose(0.0, 5.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case BIT_3: {
                return this.poseFactory.createPose(35.5, 5.0, 7.5, 0.0, 180.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
        }
        throw new IllegalArgumentException("Unsupported bit");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitChangingStation)) {
            return false;
        }
        return ((BitChangingStation)o).id.equals(this.id);
    }

    private static class TeachPoints {
        @NotNull
        final Vector3D pointA;
        @NotNull
        final Vector3D pointB;
        @NotNull
        final Vector3D pointC;

        private TeachPoints(@NotNull Vector3D pointA, @NotNull Vector3D pointB, @NotNull Vector3D pointC) {
            this.pointA = pointA;
            this.pointB = pointB;
            this.pointC = pointC;
        }

        @NotNull
        static TeachPoints createAndVerifyFromUnorderedPositions(@NotNull Position position1, @NotNull Position position2, @NotNull Position position3) throws InvalidTeachPoints {
            Vector3D point1 = PoseMath.asApachePosition(position1);
            Vector3D point2 = PoseMath.asApachePosition(position2);
            Vector3D point3 = PoseMath.asApachePosition(position3);
            List<PointAndAdjacentDistance> pointsAndDistances = Stream.of(new PointAndAdjacentDistance(point1, point2.distance((Vector)point3)), new PointAndAdjacentDistance(point2, point3.distance((Vector)point1)), new PointAndAdjacentDistance(point3, point1.distance((Vector)point2))).sorted(Comparator.comparingDouble(value -> value.adjacentEdgeDistance)).collect(Collectors.toList());
            TeachPoints.throwIfInvalidDistances(pointsAndDistances);
            Vector3D adjacentToShortestEdge = pointsAndDistances.get((int)0).point;
            Vector3D adjacentToMiddleEdge = pointsAndDistances.get((int)1).point;
            Vector3D adjacentToLongestEdge = pointsAndDistances.get((int)2).point;
            return new TeachPoints(adjacentToMiddleEdge, adjacentToLongestEdge, adjacentToShortestEdge);
        }

        private static void throwIfInvalidDistances(@NotNull List<PointAndAdjacentDistance> edgeDistances) throws InvalidTeachPoints {
            double shortest = edgeDistances.get((int)0).adjacentEdgeDistance;
            double middle = edgeDistances.get((int)1).adjacentEdgeDistance;
            double longest = edgeDistances.get((int)2).adjacentEdgeDistance;
            double expectedShortest = 0.045;
            double expectedMiddle = 0.13;
            double expectedLongest = 0.13757;
            double tolerance = 0.01;
            if (!(Precision.equals((double)shortest, (double)0.045, (double)0.01) && Precision.equals((double)middle, (double)0.13, (double)0.01) && Precision.equals((double)longest, (double)0.13757, (double)0.01))) {
                throw new InvalidTeachPoints();
            }
        }

        private static class PointAndAdjacentDistance {
            @NotNull
            final Vector3D point;
            final double adjacentEdgeDistance;

            PointAndAdjacentDistance(@NotNull Vector3D point, double adjacentEdgeDistance) {
                this.point = point;
                this.adjacentEdgeDistance = adjacentEdgeDistance;
            }
        }
    }

    public static class InvalidTeachPoints
    extends Exception {
    }

    public static enum Bit {
        BIT_1,
        BIT_2,
        BIT_3;

    }
}

