/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bridge_tool;

import com.spin.bridge_communication.BridgeInterfaceProvider;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.bridge_communication.discovery.DiscoveryConsumer;
import com.spin.bridge_communication.discovery.DiscoveryProvider;
import com.spin.bridge_communication.proxy.BridgeConfigurator;
import com.spin.bridge_communication.proxy.BridgeConnector;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusListener;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusProvider;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolData;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolView;
import com.spin.domain.BridgeInfo;
import com.spin.domain.DiscoveredBridge;
import com.spin.domain.ToolInfo;
import com.spin.util.ExhibitionMode;
import com.spin.util.api.ExtendedInstallationAPIProvider;
import com.spin.util.stream.OptionalUtil;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BridgeAndToolContribution
implements InstallationNodeContribution {
    @NotNull
    private final BridgeAndToolView view;
    @NotNull
    private final BridgeAndToolData data;
    @NotNull
    private final BridgeConnector bridgeConnector;
    @NotNull
    private final BridgeConfigurator bridgeConfigurator;
    @NotNull
    private final BridgeConnectionStatusProvider bridgeConnectionStatusProvider;
    @NotNull
    private final ToolConnectionStatusProvider toolConnectionStatusProvider;
    @NotNull
    private final BridgeConnectionStatusListener bridgeConnectionListener;
    @NotNull
    private final ToolConnectionStatusListener toolConnectionListener;
    @NotNull
    private final KeyboardInputFactory keyboardFactory;
    @NotNull
    private final DiscoveryProvider discoveryProvider;
    @NotNull
    private final DiscoveryConsumer discoveryConsumer;

    public BridgeAndToolContribution(@NotNull BridgeAndToolView view, @NotNull BridgeAndToolData data, @NotNull ExtendedInstallationAPIProvider apiProvider, @NotNull BridgeInterfaceProvider bridgeInterfaceProvider, @NotNull BridgeConnector bridgeConnector) {
        this.view = view;
        this.data = data;
        this.bridgeConnector = bridgeConnector;
        this.bridgeConfigurator = bridgeInterfaceProvider.getBridgeConfigurator();
        this.bridgeConnectionStatusProvider = bridgeInterfaceProvider.getBridgeConnectionStatusProvider();
        this.toolConnectionStatusProvider = bridgeInterfaceProvider.getToolConnectionStatusProvider();
        this.discoveryProvider = bridgeInterfaceProvider.getDiscoveryProvider();
        this.discoveryConsumer = this.createDiscoveryConsumer();
        this.bridgeConnectionListener = this.createBridgeConnectionListener();
        this.toolConnectionListener = this.createToolConnectionListener();
        this.keyboardFactory = apiProvider.getInstallationAPIProvider().getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        InetAddress bridgeIPAddress = data.bridgeIP();
        view.setBridgeIPAddress(bridgeIPAddress);
        bridgeConnector.connectTo(bridgeIPAddress);
    }

    public void openView() {
        this.updateConnectionStatusOnView();
        this.registerConnectionListeners();
        this.registerDiscoveryConsumers();
        this.updateOnlineBridges();
    }

    public void closeView() {
        this.unregisterConnectionListeners();
        this.unregisterDiscoveryConsumer();
    }

    public void generateScript(ScriptWriter writer) {
    }

    @NotNull
    KeyboardTextInput getBridgeIPKeyboard() {
        KeyboardTextInput keyboard = this.keyboardFactory.createIPAddressKeyboardInput();
        keyboard.setInitialValue(this.data.bridgeIP().getHostAddress());
        return keyboard;
    }

    void onBridgeIPChanged(@NotNull InetAddress address) {
        this.data.storeBridgeIP(address);
        this.bridgeConnector.connectTo(address);
        this.updateOnlineBridges();
    }

    private void updateOnlineBridges() {
        ArrayList<DiscoveredBridge> bridges = this.discoveryProvider.onlineBridges();
        this.view.updateOnlineBridges(bridges);
        this.view.setBridgeIPAddress(this.data.bridgeIP());
    }

    private void updateConnectionStatusOnView() {
        OptionalUtil.ifPresentOrElse(this.bridgeConnectionStatusProvider.getInfo(), this.view::setBridgeConnected, this.view::setBridgeDisconnected);
        OptionalUtil.ifPresentOrElse(this.toolConnectionStatusProvider.getInfo(), this.view::setToolConnected, this.view::setToolDisconnected);
    }

    private void registerConnectionListeners() {
        this.bridgeConnectionStatusProvider.registerListener(this.bridgeConnectionListener);
        this.toolConnectionStatusProvider.registerListener(this.toolConnectionListener);
    }

    private void unregisterConnectionListeners() {
        this.bridgeConnectionStatusProvider.unregisterListener(this.bridgeConnectionListener);
        this.toolConnectionStatusProvider.unregisterListener(this.toolConnectionListener);
    }

    private void registerDiscoveryConsumers() {
        this.discoveryProvider.registerConsumer(this.discoveryConsumer);
    }

    private void unregisterDiscoveryConsumer() {
        this.discoveryProvider.unregisterConsumer(this.discoveryConsumer);
    }

    @NotNull
    private BridgeConnectionStatusListener createBridgeConnectionListener() {
        return new BridgeConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull BridgeInfo info) {
                BridgeAndToolContribution.this.view.setBridgeConnected(info);
            }

            @Override
            public void onDisconnected() {
                BridgeAndToolContribution.this.view.setBridgeDisconnected();
            }
        };
    }

    @NotNull
    private DiscoveryConsumer createDiscoveryConsumer() {
        return bridges -> {
            this.view.updateOnlineBridges(bridges);
            this.view.setBridgeIPAddress(this.data.bridgeIP());
        };
    }

    @NotNull
    private ToolConnectionStatusListener createToolConnectionListener() {
        return new ToolConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull ToolInfo info) {
                BridgeAndToolContribution.this.view.setToolConnected(info);
            }

            @Override
            public void onDisconnected() {
                BridgeAndToolContribution.this.view.setToolDisconnected();
            }
        };
    }

    private static void toggleExhibitionModeOnRobot() {
        try {
            ExhibitionMode.toggle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void toggleExhibitionMode() {
        BridgeAndToolContribution.toggleExhibitionModeOnRobot();
        if (ExhibitionMode.isEnabled()) {
            this.bridgeConfigurator.enableExhibitionMode();
        }
    }

    @NotNull
    public InetAddress getBridgeIPAddress() {
        return this.data.bridgeIP();
    }
}

