/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.unit;

import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Torque;
import org.jetbrains.annotations.NotNull;

public class MetricConverter
extends UnitConverter {
    @NotNull
    private final SimpleValueFactory valueFactory;

    MetricConverter(@NotNull SimpleValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    @NotNull
    public String lengthLabel() {
        return "mm";
    }

    @Override
    @NotNull
    public String forceLabel() {
        return "N";
    }

    @Override
    @NotNull
    public String massLabel() {
        return "kg";
    }

    @Override
    @NotNull
    public String speedLabel() {
        return "mm/s";
    }

    @Override
    @NotNull
    public String torqueLabel() {
        return "Nm";
    }

    @Override
    @NotNull
    public String angleLabel() {
        return "\u00b0";
    }

    @Override
    public double valueOf(@NotNull Length length) {
        return length.getAs(Length.Unit.MM);
    }

    @Override
    public double valueOf(@NotNull Force force) {
        return force.getAs(Force.Unit.N);
    }

    @Override
    public double valueOf(@NotNull Mass mass) {
        return mass.getAs(Mass.Unit.KG);
    }

    @Override
    public double valueOf(@NotNull Speed speed) {
        return speed.getAs(Speed.Unit.MM_S);
    }

    @Override
    public double valueOf(@NotNull Torque torque) {
        return torque.getAs(Torque.Unit.NM);
    }

    @Override
    public double valueOf(@NotNull Angle angle) {
        return angle.getAs(Angle.Unit.DEG);
    }

    @Override
    @NotNull
    protected Length asLength(double value) {
        return this.valueFactory.createLength(value, Length.Unit.MM);
    }

    @Override
    @NotNull
    protected Force asForce(double value) {
        return this.valueFactory.createForce(value, Force.Unit.N);
    }

    @Override
    @NotNull
    protected Mass asMass(double value) {
        return this.valueFactory.createMass(value, Mass.Unit.KG);
    }

    @Override
    @NotNull
    protected Speed asSpeed(double value) {
        return this.valueFactory.createSpeed(value, Speed.Unit.MM_S);
    }

    @Override
    @NotNull
    protected Torque asTorque(double value) {
        return this.valueFactory.createTorque(value, Torque.Unit.NM);
    }

    @Override
    @NotNull
    protected Angle asAngle(double value) {
        return this.valueFactory.createAngle(value, Angle.Unit.DEG);
    }
}

