/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import java.net.InetAddress;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

public class DiscoveredBridge {
    @NotNull
    private final String name;
    @NotNull
    private final InetAddress ip;
    @NotNull
    private final LocalDateTime lastSeen;

    public DiscoveredBridge(@NotNull String name, @NotNull InetAddress ip, @NotNull LocalDateTime lastSeen) {
        this.name = name;
        this.ip = ip;
        this.lastSeen = lastSeen;
    }

    public DiscoveredBridge(@NotNull InetAddress address) {
        this.name = "";
        this.ip = address;
        this.lastSeen = LocalDateTime.now();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public InetAddress ip() {
        return this.ip;
    }

    @NotNull
    public LocalDateTime lastSeen() {
        return this.lastSeen;
    }

    @NotNull
    public String toString() {
        if (this.name.isEmpty()) {
            return this.ip.getHostAddress();
        }
        return this.name + " (" + this.ip.getHostAddress() + ")";
    }
}

