/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.inputfield;

import com.spin.ui.component.TextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputField<ValueType> {
    @NotNull
    private final TextField textField = new TextField();
    @NotNull
    private Renderer<ValueType> renderer = value -> value == null ? null : value.toString();
    @Nullable
    private ValueType value = null;

    public InputField(@NotNull Alignment number) {
        switch (number) {
            case TEXT: {
                this.textField.setHorizontalAlignment(2);
                break;
            }
            case NUMBER: {
                this.textField.setHorizontalAlignment(4);
            }
        }
    }

    @NotNull
    public TextField getTextField() {
        return this.textField;
    }

    @Nullable
    public ValueType getValue() {
        return this.value;
    }

    public void setValue(@Nullable ValueType value) {
        this.value = value;
        String text = this.renderer.textFrom(value);
        this.textField.setText(text);
    }

    public void setRenderer(@NotNull Renderer<ValueType> renderer) {
        this.renderer = renderer;
    }

    public static interface Renderer<ValueType> {
        @Nullable
        public String textFrom(@Nullable ValueType var1);
    }

    public static enum Alignment {
        TEXT,
        NUMBER;

    }
}

