/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.script_function;

import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class ScriptFunction
extends Enum<ScriptFunction> {
    public static final /* enum */ ScriptFunction ACKNOWLEDGE_ERRORS = new ScriptFunction("spin_acknowledge_errors", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_STOP = new ScriptFunction("spin_ss_stop", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_DO_HOMING = new ScriptFunction("spin_ss_do_homing", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_RELEASE_BIT = new ScriptFunction("spin_ss_release_bit", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_LOCK_BIT = new ScriptFunction("spin_ss_lock_bit", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_COVER_BIT = new ScriptFunction("spin_ss_cover_bit", new Argument[0]);
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_COVER_SCREW = new ScriptFunction("spin_ss_cover_screw", new Argument("screw_length_mm", ArgumentType.LENGTH_MM));
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_MOVE_TO_POSITION = new ScriptFunction("spin_ss_move_to_position", new Argument("position_mm", ArgumentType.POSITION_MM));
    public static final /* enum */ ScriptFunction SAFETY_SHIELD_FOLLOW_ROBOT = new ScriptFunction("spin_ss_follow_robot", new Argument[0]);
    public static final /* enum */ ScriptFunction STOP_MOTOR = new ScriptFunction("spin_motor_stop", new Argument[0]);
    public static final /* enum */ ScriptFunction START_MOTOR = new ScriptFunction("spin_motor_start", new Argument("cw_speed_rpm", ArgumentType.ANGULAR_SPEED_RPM));
    public static final /* enum */ ScriptFunction LATEST_RESULT_UUID = new ScriptFunction("spin_latest_result_uuid", new Argument[0]);
    @NotNull
    private final String functionName;
    @NotNull
    private final Argument[] arguments;
    private static final /* synthetic */ ScriptFunction[] $VALUES;

    public static ScriptFunction[] values() {
        return (ScriptFunction[])$VALUES.clone();
    }

    public static ScriptFunction valueOf(String name) {
        return Enum.valueOf(ScriptFunction.class, name);
    }

    private ScriptFunction(String functionName, Argument ... arguments) {
        this.functionName = functionName;
        this.arguments = arguments;
    }

    @NotNull
    static InputStream scriptStream() {
        InputStream scriptStream = ScriptFunction.class.getResourceAsStream("tool_functions.script");
        assert (scriptStream != null) : "Script resource file not found";
        return scriptStream;
    }

    @NotNull
    public String functionName() {
        return this.functionName;
    }

    @NotNull
    public Argument[] arguments() {
        return this.arguments;
    }

    @NotNull
    public String[] argumentNames() {
        return (String[])Arrays.stream(this.arguments).map(Argument::name).toArray(String[]::new);
    }

    static {
        $VALUES = new ScriptFunction[]{ACKNOWLEDGE_ERRORS, SAFETY_SHIELD_STOP, SAFETY_SHIELD_DO_HOMING, SAFETY_SHIELD_RELEASE_BIT, SAFETY_SHIELD_LOCK_BIT, SAFETY_SHIELD_COVER_BIT, SAFETY_SHIELD_COVER_SCREW, SAFETY_SHIELD_MOVE_TO_POSITION, SAFETY_SHIELD_FOLLOW_ROBOT, STOP_MOTOR, START_MOTOR, LATEST_RESULT_UUID};
    }

    public static class Argument {
        @NotNull
        private final String name;
        @NotNull
        private final ArgumentType type;

        public Argument(@NotNull String name, @NotNull ArgumentType type) {
            this.name = name;
            this.type = type;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public ArgumentType type() {
            return this.type;
        }
    }

    public static enum ArgumentType {
        ANGULAR_SPEED_RPM,
        LENGTH_MM,
        POSITION_MM;

    }
}

