/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.domain.Program;
import com.spin.domain.program_goal.ExtractionGoal;
import com.spin.domain.program_goal.ProgramGoal;
import com.spin.i18n.TextResource;
import com.spin.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DriveScrewScriptGenerator {
    public void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull TextResource textResource, @NotNull ScrewdrivingSetupData data) {
        Pose insertPose = Objects.requireNonNull(data.screwPose());
        Program selectedProgram = Objects.requireNonNull(data.selectedProgram());
        ProgramGoal programGoal = selectedProgram.goal();
        boolean isExtraction = programGoal instanceof ExtractionGoal;
        InputStream insertScrewScript = Objects.requireNonNull(this.getClass().getResourceAsStream("DriveScrew.script"));
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(insertScrewScript, data.useSpinTarget() ? scriptWriter.getResolvedVariableName(data.spinTargetVariable()) : this.poseToScriptString(insertPose), Double.toString(selectedProgram.screw().length().getAs(Length.Unit.M)), Integer.toString(selectedProgram.id()), this.boolToString(isExtraction), Double.toString(data.robotForce().getAs(Force.Unit.N)), Double.toString(data.s1Distance().getAs(Length.Unit.M)), this.boolToString(data.approachIsEnabled()), "\"" + textResource.load(ScrewdrivingSetupText.ERROR_TITLE) + "\"");
    }

    private String poseToScriptString(@NotNull Pose pose) {
        double[] values = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        assert (values.length == 6);
        return String.format("p[%f, %f, %f, %f, %f, %f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private String boolToString(@NotNull Boolean bool) {
        return bool != false ? "True" : "False";
    }
}

