/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.unload_screw.UnloadScrewData;
import com.spin.core.program_node.unload_screw.UnloadScrewScriptGenerator;
import com.spin.core.program_node.unload_screw.UnloadScrewText;
import com.spin.core.program_node.unload_screw.UnloadScrewView;
import com.spin.domain.ScrewFeeder;
import com.spin.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;

public class UnloadScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final UnloadScrewView view;
    @NotNull
    private final UnloadScrewData data;
    @NotNull
    private final UnloadScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final InstallationContribution installationContribution;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final PoseFactory poseFactory;

    UnloadScrewContribution(@NotNull UnloadScrewView unloadScrewView, @NotNull UnloadScrewData data, @NotNull UnloadScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = unloadScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.poseFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getPoseFactory();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
    }

    public void openView() {
        this.view.setScrewFeeders(this.installationContribution.getScrewFeeders());
        this.view.selectedScrewFeeder(this.data.selectedScrewFeeder());
        this.view.setApproachEnabled(this.data.approachEnabled());
        this.view.setDepartEnabled(this.data.departEnabled());
        this.view.setCallToAction(this.data.getPose());
    }

    public void closeView() {
    }

    public String getTitle() {
        String title = this.textResource.load(UnloadScrewText.UNLOAD_SCREW);
        return title;
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    void onExitVerifyPosition() {
        this.view.toggleActivePanel();
    }

    void selectScrewFeeder(ScrewFeeder screwFeeder) {
        this.data.setSelectedScrewFeeder(screwFeeder);
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    public void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    public void setDepartEnabled(boolean enabled) {
        this.data.setDepartEnabled(enabled);
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setPose(Pose pose) {
        this.data.setPose(pose);
    }

    public Pose poseAbove() {
        Pose pose = this.data.getPose();
        Pose poseAbove = this.poseFactory.createPose(pose.getPosition().getX(Length.Unit.MM), pose.getPosition().getY(Length.Unit.MM), pose.getPosition().getZ(Length.Unit.MM) + 50.0, pose.getRotation().getRX(Angle.Unit.DEG), pose.getRotation().getRY(Angle.Unit.DEG), pose.getRotation().getRZ(Angle.Unit.DEG), Length.Unit.MM, Angle.Unit.DEG);
        return poseAbove;
    }

    public Pose pose() {
        return this.data.getPose();
    }
}

