/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.tool_action;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.program_node.tool_action.ToolActionContribution;
import com.spin.core.program_node.tool_action.ToolActionText;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.core.program_node.tool_action.ToolFunctionHolder;
import com.spin.i18n.TextResource;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.component.inputfield.UnitRenderer;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolActionView
implements SwingProgramNodeView<ToolActionContribution> {
    @NotNull
    private final ComboBox<ToolFunctionHolder> actionSelector;
    @NotNull
    private final JPanel inputPanel;
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final ButtonMedium testButton;
    @NotNull
    private final UnitType unitType;
    @NotNull
    private final Label angularSpeedUnit;
    @NotNull
    private final InputField<Integer> angularSpeedField;
    @NotNull
    private final Label screwLengthUnit;
    @NotNull
    private final InputField<Length> screwLengthField;
    @NotNull
    private final Label absolutePositionUnit;
    @NotNull
    private final InputField<Length> absolutePositionField;
    @NotNull
    private final List<JComponent> inputPanels;
    @NotNull
    private final Map<ToolFunction, JComponent> functionPanelMapping = new HashMap<ToolFunction, JComponent>();

    public ToolActionView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.unitType = apiProvider.getViewAPIProvider().getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        this.screwLengthUnit = new Label();
        this.absolutePositionUnit = new Label();
        this.angularSpeedUnit = new Label();
        TextResource textResource = apiProvider.getTextResource();
        this.actionSelector = new ComboBox();
        this.actionSelector.setDefaultText(textResource.load(ToolActionText.NONE));
        for (ToolFunction toolFunction : ToolFunction.values()) {
            this.actionSelector.addItem(new ToolFunctionHolder(toolFunction, textResource.load(toolFunction)));
        }
        this.inputPanel = new JPanel((LayoutManager)UR_MigLayout.singleColumn(10));
        JPanel screwLengthPanel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[]"));
        this.screwLengthField = new InputField(InputField.Alignment.NUMBER);
        screwLengthPanel.add((Component)new Label(textResource.load(ToolActionText.SCREW_LENGTH)), "cell 0 0");
        screwLengthPanel.add((Component)this.screwLengthField.getTextField(), "cell 1 0, span 2,grow");
        screwLengthPanel.add((Component)this.screwLengthUnit, "cell 3 0");
        JPanel absolutPositionPanel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[]"));
        this.absolutePositionField = new InputField(InputField.Alignment.NUMBER);
        absolutPositionPanel.add((Component)new Label(textResource.load(ToolActionText.ABSOLUTE_POSITION)), "cell 0 0");
        absolutPositionPanel.add((Component)this.absolutePositionField.getTextField(), "cell 1 0,span 2, grow");
        absolutPositionPanel.add((Component)this.absolutePositionUnit, "cell 3 0");
        JPanel angularSpeedPanel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[]"));
        this.angularSpeedField = new InputField(InputField.Alignment.NUMBER);
        angularSpeedPanel.add((Component)new Label(textResource.load(ToolActionText.MOTOR_SPEED)), "cell 0 0");
        angularSpeedPanel.add((Component)this.angularSpeedField.getTextField(), "cell 1 0, span 2,grow");
        angularSpeedPanel.add((Component)this.angularSpeedUnit, "cell 3 0");
        this.inputPanel.add((Component)screwLengthPanel, "cell 0 0, grow, hidemode 3");
        this.inputPanel.add((Component)absolutPositionPanel, "cell 0 0, grow, hidemode 3");
        this.inputPanel.add((Component)angularSpeedPanel, "cell 0 0, grow, hidemode 3");
        this.testButton = new ButtonMedium(textResource.load(ToolActionText.TEST));
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.inputPanels = Arrays.asList(screwLengthPanel, absolutPositionPanel, angularSpeedPanel);
        this.functionPanelMapping.put(ToolFunction.SAFETY_SHIELD_COVER_SCREW, screwLengthPanel);
        this.functionPanelMapping.put(ToolFunction.SAFETY_SHIELD_MOVE_TO_POSITION, absolutPositionPanel);
        this.functionPanelMapping.put(ToolFunction.START_MOTOR, angularSpeedPanel);
        this.showOptionsPanelFor(null);
    }

    void setUnitConverter(@NotNull UnitConverter unitConverter) {
        UnitRenderer renderer = new UnitRenderer(unitConverter, new DecimalFormat("#.##"));
        String unit = unitConverter.labelOf(Length.class);
        this.screwLengthUnit.setText(unit);
        this.screwLengthField.setRenderer(renderer);
        this.absolutePositionUnit.setText(unit);
        this.absolutePositionField.setRenderer(renderer);
        this.angularSpeedUnit.setText("RPM");
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ContributionProvider<ToolActionContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][]push[][]"));
        panel.add(this.actionSelector, "cell 0 0, span 7, grow");
        panel.add((Component)this.inputPanel, "cell 0 1, span 12");
        panel.add((Component)this.testButton, "cell 8 2, span 3, grow,right");
        panel.add((Component)this.logo, "cell 0 3, span 4, left");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<ToolActionContribution> provider) {
        this.actionSelector.addActionListener(e -> {
            ToolFunctionHolder selectedFunction = (ToolFunctionHolder)this.actionSelector.getSelectedItem();
            if (selectedFunction != null) {
                ((ToolActionContribution)provider.get()).selectFunction(selectedFunction.getToolFunction());
                this.showOptionsPanelFor(selectedFunction.getToolFunction());
            }
        });
        this.screwLengthField.getTextField().addSimpleClickListener(() -> this.showScrewLengthKeypad((ToolActionContribution)provider.get()));
        this.absolutePositionField.getTextField().addSimpleClickListener(() -> this.showAbsolutePositionKeypad((ToolActionContribution)provider.get()));
        this.angularSpeedField.getTextField().addSimpleClickListener(() -> this.showAngularSpeedKeypad((ToolActionContribution)provider.get()));
        this.testButton.addActionListener(event -> ((ToolActionContribution)provider.get()).execute());
    }

    void showOptionsPanelFor(@Nullable ToolFunction toolFunction) {
        JComponent panelToShow = this.functionPanelMapping.getOrDefault(toolFunction, null);
        this.inputPanels.forEach(panel -> panel.setVisible(panel == panelToShow));
    }

    void setSelectedFunction(@Nullable ToolFunction toolFunction) {
        if (toolFunction == null) {
            this.actionSelector.setSelectedItem(null);
            this.showOptionsPanelFor(null);
        }
        int count = this.actionSelector.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (((ToolFunctionHolder)this.actionSelector.getItemAt(i)).getToolFunction() != toolFunction) continue;
            this.actionSelector.setSelectedIndex(i);
            this.showOptionsPanelFor(toolFunction);
            return;
        }
    }

    void setAbsolutePositionField(@Nullable Length absolutePosition) {
        this.absolutePositionField.setValue(absolutePosition);
        this.updateComponents();
    }

    void setScrewLengthField(@Nullable Length screwLength) {
        this.screwLengthField.setValue(screwLength);
        this.updateComponents();
    }

    void setAngularSpeedField(@Nullable Integer angularSpeedRPM) {
        this.angularSpeedField.setValue(angularSpeedRPM);
        this.updateComponents();
    }

    private void showScrewLengthKeypad(@NotNull ToolActionContribution contribution) {
        Length initialValue = this.screwLengthField.getValue();
        UnitKeypad<Number, Length> keypad = this.unitType == UnitType.METRIC ? contribution.getScrewLengthIntegerKeypad(initialValue) : contribution.getScrewLengthDoubleKeypad(initialValue);
        keypad.show(this.screwLengthField.getTextField(), length -> this.setScrewLength((Length)length, contribution));
    }

    private void showAbsolutePositionKeypad(@NotNull ToolActionContribution contribution) {
        Length initialValue = this.absolutePositionField.getValue();
        UnitKeypad<Number, Length> keypad = this.unitType == UnitType.METRIC ? contribution.getScrewLengthIntegerKeypad(initialValue) : contribution.getScrewLengthDoubleKeypad(initialValue);
        keypad.show(this.absolutePositionField.getTextField(), absolutePosition -> this.setAbsolutePosition((Length)absolutePosition, contribution));
    }

    private void showAngularSpeedKeypad(@NotNull ToolActionContribution contribution) {
        Integer initialValue = this.angularSpeedField.getValue();
        KeyboardNumberInput<Integer> keypad = contribution.getAngularSpeedIntegerKeypad(initialValue);
        keypad.show((JTextField)this.angularSpeedField.getTextField(), new OnOkCallback<Integer>(angularSpeed -> this.setAngularSpeed((Integer)angularSpeed, contribution)));
    }

    private void setScrewLength(@NotNull Length length, @NotNull ToolActionContribution contribution) {
        this.screwLengthField.setValue(length);
        contribution.setScrewLength(length);
        this.updateComponents();
    }

    private void setAbsolutePosition(@NotNull Length absolute_position, @NotNull ToolActionContribution contribution) {
        this.absolutePositionField.setValue(absolute_position);
        contribution.setAbsolutePosition(absolute_position);
        this.updateComponents();
    }

    private void setAngularSpeed(@NotNull Integer angularSpeedRPM, @NotNull ToolActionContribution contribution) {
        this.angularSpeedField.setValue(angularSpeedRPM);
        contribution.setAngularSpeed(angularSpeedRPM);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean screwLengthValid = this.screwLengthField.getValue() != null;
        boolean absolutePositionValid = this.absolutePositionField.getValue() != null;
        boolean angularSpeedValid = this.angularSpeedField.getValue() != null;
        this.screwLengthField.getTextField().setInputValid(screwLengthValid);
        this.absolutePositionField.getTextField().setInputValid(absolutePositionValid);
        this.angularSpeedField.getTextField().setInputValid(angularSpeedValid);
    }
}

