/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.api.ExtendedInstallationAPIProvider;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationData;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationText;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationView;
import com.spin.domain.BitChangingStation;
import com.spin.ui.component.keyboard.NameValidator;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitChangingStationContribution
implements InstallationNodeContribution {
    @NotNull
    private final BitChangingStationView view;
    @NotNull
    private final BitChangingStationData data;
    @NotNull
    private final ExtendedInstallationAPIProvider apiProvider;
    @NotNull
    private BitChangingStationView.Panel panelToReturnTo = BitChangingStationView.Panel.DETAILS;

    public BitChangingStationContribution(@NotNull BitChangingStationView view, @NotNull BitChangingStationData data, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.apiProvider = apiProvider;
        view.getDetailsView().setStations(data.bitChangingStations());
        view.setActivePanel(BitChangingStationView.Panel.DETAILS);
    }

    public void openView() {
    }

    public void closeView() {
    }

    public void generateScript(@NotNull ScriptWriter writer) {
    }

    @NotNull
    ExtendedInstallationAPIProvider getAPIProvider() {
        return this.apiProvider;
    }

    @NotNull
    ValueFactoryProvider getValueFactoryProvider() {
        return this.apiProvider.getInstallationAPIProvider().getInstallationAPI().getValueFactoryProvider();
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.apiProvider.getInstallationAPIProvider().getUserInterfaceAPI().getUserInteraction();
    }

    void storeStation(@NotNull BitChangingStation station) {
        this.data.storeBitChangingStation(station);
        this.view.getDetailsView().setStations(this.data.bitChangingStations());
        this.view.getDetailsView().selectStationByID(station.id());
    }

    void removeStation(@NotNull BitChangingStation station) {
        this.data.removeBitChangingStation(station);
        this.view.getDetailsView().setStations(this.data.bitChangingStations());
    }

    void onAddNewStation() {
        this.view.getEditView().clearStation();
        this.view.setActivePanel(BitChangingStationView.Panel.EDIT_STATION);
    }

    void onEditExistingStation(@NotNull BitChangingStation station) {
        this.view.getEditView().setStation(station);
        this.view.setActivePanel(BitChangingStationView.Panel.EDIT_STATION);
    }

    void onExitEditStation() {
        this.view.setActivePanel(BitChangingStationView.Panel.DETAILS);
    }

    void onVerifyPositionFromEditView(@NotNull Pose aboveBPose, @NotNull Pose atBPose) {
        this.panelToReturnTo = BitChangingStationView.Panel.EDIT_STATION;
        this.view.getVerifyPositionView().resetWithPoses(aboveBPose, atBPose);
        this.view.setActivePanel(BitChangingStationView.Panel.VERIFY_POSITION);
    }

    void onVerifyPositionFromDetailsView(@NotNull Pose aboveBPose, @NotNull Pose atBPose) {
        this.panelToReturnTo = BitChangingStationView.Panel.DETAILS;
        this.view.getVerifyPositionView().resetWithPoses(aboveBPose, atBPose);
        this.view.setActivePanel(BitChangingStationView.Panel.VERIFY_POSITION);
    }

    void onExitVerifyPosition() {
        this.view.setActivePanel(this.panelToReturnTo);
    }

    @NotNull
    KeyboardTextInput getStationNameKeyboard(@Nullable String initialName) {
        Collection disallowedNames = this.data.bitChangingStations().stream().map(BitChangingStation::name).filter(name -> !name.equals(initialName)).collect(Collectors.toSet());
        String helpMessage = this.apiProvider.getTextResource().load(BitChangingStationText.NAME_IN_USE_HELP_TEXT);
        KeyboardTextInput keyboard = this.apiProvider.getInstallationAPIProvider().getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createStringKeyboardInput();
        keyboard.setInitialValue(initialName);
        keyboard.setErrorValidator((InputValidator)new NameValidator(disallowedNames, helpMessage));
        return keyboard;
    }

    @NotNull
    public Set<BitChangingStation> getBitChangingStations() {
        return this.data.bitChangingStations();
    }
}

