/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar;

import com.spin.ui.component.ImagePanel;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.layout.UR_MigLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ToolbarConnectionView {
    @NotNull
    private final ImageIcon connectionOKIcon = SpinIcon.CONNECTION_OK_SMALL.load();
    @NotNull
    private final ImageIcon connectionNotOKIcon = SpinIcon.CONNECTION_NOT_OK_SMALL.load();
    @NotNull
    private final ImageIcon connectionUnknownIcon = SpinIcon.CONNECTION_UNKNOWN_SMALL.load();
    @NotNull
    private final ImagePanel bridgeConnectionImage = new ImagePanel(this.connectionNotOKIcon);
    @NotNull
    private final ImagePanel toolConnectionImage = new ImagePanel(this.connectionUnknownIcon);
    private boolean bridgeIsConnected = false;
    private boolean toolIsConnected = false;

    ToolbarConnectionView() {
    }

    void buildUI(@NotNull JPanel jPanel) {
        Dimension imageDimension = new Dimension(-1, 64);
        jPanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 5, "[]"));
        jPanel.add((Component)new ImagePanel(SpinImage.ROBOT.load(imageDimension)), "cell 0 1, span 2, align 70%");
        jPanel.add((Component)new ImagePanel(SpinImage.BRIDGE.load(imageDimension)), "cell 3 1, span 5, align 60%");
        jPanel.add((Component)new ImagePanel(SpinImage.TOOL.load(imageDimension)), "cell 8 1, span 4, align 56%");
        jPanel.add((Component)this.bridgeConnectionImage, "cell 2 1, span 3");
        jPanel.add((Component)this.toolConnectionImage, "cell 7 1, span 3");
    }

    void setBridgeDisconnected() {
        this.bridgeIsConnected = false;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setBridgeConnected() {
        this.bridgeIsConnected = true;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setToolDisconnected() {
        this.toolIsConnected = false;
        this.updateToolConnection();
    }

    void setToolConnected() {
        this.toolIsConnected = true;
        this.updateToolConnection();
    }

    private void updateBridgeConnection() {
        if (this.bridgeIsConnected) {
            this.showBridgeConnected();
        } else {
            this.showBridgeDisconnected();
        }
    }

    private void updateToolConnection() {
        if (!this.bridgeIsConnected) {
            this.showToolConnectionUnknown();
        } else if (this.toolIsConnected) {
            this.showToolConnected();
        } else {
            this.showToolDisconnected();
        }
    }

    private void showBridgeDisconnected() {
        this.bridgeConnectionImage.setIcon(this.connectionNotOKIcon);
    }

    private void showBridgeConnected() {
        this.bridgeConnectionImage.setIcon(this.connectionOKIcon);
    }

    private void showToolConnectionUnknown() {
        this.toolConnectionImage.setIcon(this.connectionUnknownIcon);
    }

    private void showToolDisconnected() {
        this.toolConnectionImage.setIcon(this.connectionNotOKIcon);
    }

    void showToolConnected() {
        this.toolConnectionImage.setIcon(this.connectionOKIcon);
    }
}

