/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.hidden_nodes.move_direction;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionData;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionInterface;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionScriptGenerator;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionText;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionView;
import com.spin.i18n.TextResource;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectionContribution
implements ProgramNodeContribution,
MoveDirectionInterface {
    @NotNull
    private final MoveDirectionData data;
    @NotNull
    private final MoveDirectionScriptGenerator scriptGenerator;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final MoveDirectionView view;

    public MoveDirectionContribution(ExtendedProgramAPIProvider extendedProgramAPIProvider, MoveDirectionView view, MoveDirectionData moveDirectionData, MoveDirectionScriptGenerator scriptGenerator) {
        this.data = moveDirectionData;
        this.scriptGenerator = scriptGenerator;
        this.unitKeypadFactory = extendedProgramAPIProvider.getUnitKeypadFactory();
        this.textResource = extendedProgramAPIProvider.getTextResource();
        this.view = view;
        view.setUnitConverter(extendedProgramAPIProvider.getUnitConverter());
    }

    public void openView() {
        this.view.setMoveDistanceField(this.data.getMoveDistance());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(MoveDirectionText.MOVE_DIRECTION);
    }

    public boolean isDefined() {
        return this.data.getMoveDistance() != null;
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.data);
    }

    @Override
    public void setMoveDistance(Length moveDistance) {
        this.data.setMoveDistance(moveDistance);
    }

    UnitKeypad<Integer, Length> getMoveDistanceIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Length> getMoveDistanceDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }
}

