/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_not_OK;

import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayInterface;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayService;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkText;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class OnNotOkContribution
implements ProgramNodeContribution {
    @NotNull
    private final TextResource textResource;

    OnNotOkContribution(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType nodeCreationType) {
        this.textResource = apiProvider.getTextResource();
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnNotOkContribution.buildSubTree(apiProvider, this);
        }
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnNotOkContribution contribution) {
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory programNodeFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        SimpleValueFactory valueFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        try {
            OnNotOkContribution.addMoveAwayNode(rootNode, programNodeFactory, valueFactory);
            OnNotOkContribution.addSafetyShieldCoverBitNode(rootNode, programNodeFactory);
        }
        catch (TreeStructureException e) {
            SpinLog.print("Cannot add child nodes to onFault node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void addMoveAwayNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull SimpleValueFactory valueFactory) throws TreeStructureException {
        URCapProgramNode moveNode = programNodeFactory.createURCapProgramNode(MoveAwayService.class);
        rootNode.addChild((ProgramNode)moveNode);
        ((MoveAwayInterface)moveNode.getAs(MoveAwayInterface.class)).setMoveDistance(valueFactory.createLength(50.0, Length.Unit.MM));
    }

    private static void addSafetyShieldCoverBitNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        rootNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(OnNotOkText.ON_NOT_OK);
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        String errorTitle = ScriptUtil.wrapInQuotes(this.textResource.load(ScrewdrivingSetupText.ERROR_TITLE));
        writer.appendLine("else:");
        writer.appendLine("  sync()");
        writer.writeChildren();
        writer.appendLine("  sleep(0.05)");
        writer.appendLine("  program_message = spin_program_messages() ");
        writer.appendLine("  if (program_message != \"\"):");
        writer.appendLine("    popup(program_message, " + errorTitle + ", error = True, blocking=False)");
        writer.appendLine("  else:");
        writer.appendLine("    popup(spin_error_messages(), " + errorTitle + ", error = True, blocking=False)");
        writer.appendLine("  end");
        writer.appendLine("  halt");
        writer.appendLine("end");
    }
}

