/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node;

import com.spin.bridge_communication.BridgeInterfaceProvider;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.bridge_communication.program_data.ProgramDataProvider;
import com.spin.bridge_communication.proxy.BridgeConnector;
import com.spin.bridge_communication.proxy.ToolController;
import com.spin.bridge_communication.result.ResultProvider;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusProvider;
import com.spin.core.installation_node.InstallationData;
import com.spin.core.installation_node.InstallationView;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationContribution;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolContribution;
import com.spin.core.installation_node.screw_feeder.ScrewFeederContribution;
import com.spin.core.installation_node.script_function.ScriptFunctionRegistration;
import com.spin.core.installation_node.tcp_payload.TCPAndPayloadRegistration;
import com.spin.core.installation_node.tcp_payload.ToolSpecs;
import com.spin.domain.BitChangingStation;
import com.spin.domain.ScrewFeeder;
import com.spin.util.api.ExtendedInstallationAPIProvider;
import com.spin.util.script.ScriptParser;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.InstallationAPI;
import com.ur.urcap.api.domain.function.FunctionException;
import com.ur.urcap.api.domain.function.FunctionModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.net.InetAddress;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InstallationContribution
implements InstallationNodeContribution {
    @NotNull
    private final BridgeInterfaceProvider bridgeInterfaceProvider;
    @NotNull
    private final BridgeAndToolContribution bridgeAndToolContribution;
    @NotNull
    private final ScrewFeederContribution screwFeederContribution;
    @NotNull
    private final BitChangingStationContribution bitChangingStationContribution;
    @NotNull
    private InstallationNodeContribution activeContribution;

    InstallationContribution(@NotNull InstallationView view, @NotNull InstallationData data, @NotNull ExtendedInstallationAPIProvider apiProvider, @NotNull BridgeInterfaceProvider bridgeInterfaceProvider, @NotNull BridgeConnector bridgeConnector) {
        this.bridgeInterfaceProvider = bridgeInterfaceProvider;
        this.bridgeAndToolContribution = new BridgeAndToolContribution(view.getBridgeAndToolView(), data.getBridgeAndToolData(), apiProvider, bridgeInterfaceProvider, bridgeConnector);
        this.screwFeederContribution = new ScrewFeederContribution(view.getScrewFeederView(), data.getScrewFeederData(), apiProvider);
        this.bitChangingStationContribution = new BitChangingStationContribution(view.getBitChangingStationView(), data.getBitChangingStationData(), apiProvider);
        this.activeContribution = this.bridgeAndToolContribution;
        InstallationAPI installationAPI = apiProvider.getInstallationAPIProvider().getInstallationAPI();
        ToolSpecs toolSpecs = new ToolSpecs(installationAPI);
        TCPAndPayloadRegistration.addAllNewTCPs(installationAPI.getTCPContributionModel(), toolSpecs);
        TCPAndPayloadRegistration.addAllNewPayloads(installationAPI.getPayloadContributionModel(), toolSpecs);
        InstallationContribution.addAllScriptFunctionsToModel(installationAPI.getFunctionModel());
    }

    private static void addAllScriptFunctionsToModel(@NotNull FunctionModel functionModel) {
        try {
            ScriptFunctionRegistration.addAllFunctions(functionModel);
        }
        catch (FunctionException e) {
            assert (false) : "Script function registration failed";
            throw new RuntimeException(e);
        }
    }

    public void openView() {
        this.activeContribution.openView();
    }

    public void closeView() {
        this.activeContribution.closeView();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        ScriptParser scriptParser = new ScriptParser(writer);
        ScriptFunctionRegistration.generateToolFunctionScript(scriptParser, this.getBridgeIPAddress());
        ScriptFunctionRegistration.generateUtilFunctionScript(scriptParser);
        ScriptFunctionRegistration.generateMoveFunctionScript(scriptParser);
        this.bridgeAndToolContribution.generateScript(writer);
        this.screwFeederContribution.generateScript(writer);
        this.bitChangingStationContribution.generateScript(writer);
    }

    @NotNull
    BridgeAndToolContribution getBridgeAndToolContribution() {
        return this.bridgeAndToolContribution;
    }

    @NotNull
    ScrewFeederContribution getScrewFeederContribution() {
        return this.screwFeederContribution;
    }

    @NotNull
    BitChangingStationContribution getBitChangingStationContribution() {
        return this.bitChangingStationContribution;
    }

    void setActiveContribution(@NotNull InstallationNodeContribution contributionToActivate) {
        this.activeContribution = contributionToActivate;
    }

    void onActiveContributionChange(@NotNull InstallationNodeContribution newActiveContribution) {
        this.activeContribution.closeView();
        newActiveContribution.openView();
        this.setActiveContribution(newActiveContribution);
    }

    @NotNull
    public InetAddress getBridgeIPAddress() {
        return this.bridgeAndToolContribution.getBridgeIPAddress();
    }

    @NotNull
    public Set<ScrewFeeder> getScrewFeeders() {
        return this.screwFeederContribution.getScrewFeeders();
    }

    @NotNull
    public Set<BitChangingStation> getBitChangingStations() {
        return this.bitChangingStationContribution.getBitChangingStations();
    }

    @NotNull
    public BridgeConnectionStatusProvider getBridgeConnectionStatusProvider() {
        return this.bridgeInterfaceProvider.getBridgeConnectionStatusProvider();
    }

    @NotNull
    public ToolConnectionStatusProvider getToolConnectionStatusProvider() {
        return this.bridgeInterfaceProvider.getToolConnectionStatusProvider();
    }

    @NotNull
    public ProgramDataProvider getProgramDataProvider() {
        return this.bridgeInterfaceProvider.getProgramDataProvider();
    }

    @NotNull
    public ResultProvider getResultProvider() {
        return this.bridgeInterfaceProvider.getResultProvider();
    }

    @NotNull
    public ToolController getToolController() {
        return this.bridgeInterfaceProvider.getToolController();
    }
}

