/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util.api;

import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayInterface;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayService;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CommentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.HaltNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NodeFactory {
    public static void addMoveAwayNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull SimpleValueFactory valueFactory) throws TreeStructureException {
        URCapProgramNode moveNode = programNodeFactory.createURCapProgramNode(MoveAwayService.class);
        rootNode.addChild((ProgramNode)moveNode);
        ((MoveAwayInterface)moveNode.getAs(MoveAwayInterface.class)).setMoveDistance(valueFactory.createLength(50.0, Length.Unit.MM));
    }

    public static void addSafetyShieldCoverBitNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        rootNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
    }

    public static void addAssignmentNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull Variable variable, @NotNull Expression expression) throws TreeStructureException {
        AssignmentNode assignmentNode = programNodeFactory.createAssignmentNode();
        AssignmentNodeConfigFactory assignmentNodeConfigFactory = assignmentNode.getConfigFactory();
        assignmentNode.setConfig((AssignmentNodeConfig)assignmentNodeConfigFactory.createExpressionConfig(variable, expression));
        rootNode.addChild((ProgramNode)assignmentNode);
    }

    public static void addCommentNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull String comment) throws TreeStructureException {
        CommentNode commentNode = programNodeFactory.createCommentNode();
        commentNode.setComment(comment);
        rootNode.addChild((ProgramNode)commentNode);
    }

    public static void addHaltNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        HaltNode haltNode = programNodeFactory.createHaltNode();
        rootNode.addChild((ProgramNode)haltNode);
    }

    public static Variable get_spin_message(ProgramAPI programAPI) {
        Collection variables = programAPI.getVariableModel().getAll();
        if (variables.isEmpty()) {
            SpinLog.print("No variables found");
        } else {
            SpinLog.print("Variables found:");
            for (Variable variable : variables) {
                if (variable.getDisplayName().equals("spin_message")) {
                    return variable;
                }
                SpinLog.print("  " + variable.getDisplayName());
            }
        }
        SpinLog.print("Creating variable spin_message");
        try {
            return programAPI.getVariableModel().getVariableFactory().createGlobalVariable("spin_message");
        }
        catch (VariableException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

