/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.keypad;

import com.spin.ui.component.keypad.UnitKeypadCallback;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import org.jetbrains.annotations.NotNull;

class WrappedUnitKeypadCallback<Number, Unit>
extends KeyboardInputCallback<Number> {
    @NotNull
    private final UnitKeypadCallback<Unit> unitKeypadCallback;
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final Class<Unit> unitClass;

    public WrappedUnitKeypadCallback(@NotNull UnitKeypadCallback<Unit> unitKeypadCallback, @NotNull UnitConverter unitConverter, @NotNull Class<Unit> unitClass) {
        this.unitKeypadCallback = unitKeypadCallback;
        this.unitConverter = unitConverter;
        this.unitClass = unitClass;
    }

    public void onOk(Number value) {
        Unit unitValue = this.unitConverter.asType(this.unitClass, this.asDouble(value));
        this.unitKeypadCallback.onOk(unitValue);
    }

    public void onCancel() {
        this.unitKeypadCallback.onCancel();
    }

    private double asDouble(Number value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new IllegalStateException("Unknown number type");
    }
}

