/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.tool_action;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.installation_node.script_function.ScriptFunction;
import com.spin.core.program_node.tool_action.ToolActionData;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionView;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.i18n.TextResource;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.ui.component.keypad.UnitRangeValidator;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidationFactory;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolActionContribution
implements ProgramNodeContribution,
ToolActionInterface {
    @NotNull
    private final ToolActionView view;
    @NotNull
    private final ToolActionData data;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;
    private final UserInteraction userInteraction;
    @NotNull
    private final InstallationContribution installationNode;

    ToolActionContribution(@NotNull ToolActionView view, @NotNull ToolActionData data, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.installationNode = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        this.view = view;
        this.data = data;
        this.textResource = apiProvider.getTextResource();
        this.unitKeypadFactory = apiProvider.getUnitKeypadFactory();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        UnitConverter unitConverter = apiProvider.getUnitConverter();
        view.setUnitConverter(unitConverter);
    }

    public void openView() {
        this.view.setSelectedFunction(this.data.getFunction());
        this.view.setScrewLengthField(this.data.getScrewLength());
        this.view.setAbsolutePositionField(this.data.getAbsolutPosition());
        this.view.setAngularSpeedField(this.data.getAngularSpeed());
    }

    public void closeView() {
    }

    public String getTitle() {
        ToolFunction selectedFunction = this.data.getFunction();
        return selectedFunction == null ? "Tool Action" : this.textResource.load(selectedFunction);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        ToolFunction selectedFunction = this.data.getFunction();
        assert (selectedFunction != null);
        ScriptFunction.Argument[] arguments = selectedFunction.getScriptFunction().arguments();
        block0 : switch (arguments.length) {
            case 0: {
                writer.appendLine(this.scriptBuilder(selectedFunction.getScriptFunction().functionName(), new String[0]));
                break;
            }
            case 1: {
                switch (arguments[0].type()) {
                    case ANGULAR_SPEED_RPM: {
                        writer.appendLine(this.scriptBuilder(selectedFunction.getScriptFunction().functionName(), this.data.getAngularSpeed().toString()));
                        break block0;
                    }
                    case LENGTH_MM: {
                        writer.appendLine(this.scriptBuilder(selectedFunction.getScriptFunction().functionName(), String.valueOf(this.data.getScrewLength().getAs(Length.Unit.MM))));
                        break block0;
                    }
                    case POSITION_MM: {
                        writer.appendLine(this.scriptBuilder(selectedFunction.getScriptFunction().functionName(), String.valueOf(this.data.getAbsolutPosition().getAs(Length.Unit.MM))));
                    }
                }
            }
        }
    }

    @NotNull
    private String scriptBuilder(@NotNull String functionName, String ... argument) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append(functionName);
        scriptBuilder.append("(");
        for (int i = 0; i < argument.length; ++i) {
            scriptBuilder.append(argument[i]);
            if (i >= argument.length - 1) continue;
            scriptBuilder.append(",");
        }
        scriptBuilder.append(")");
        return scriptBuilder.toString();
    }

    @Override
    public void selectFunction(@NotNull ToolFunction toolFunction) {
        this.data.setFunction(toolFunction);
    }

    void setScrewLength(@NotNull Length screwLength) {
        this.data.setScrewLength(screwLength);
    }

    void setAbsolutePosition(@NotNull Length absolutePosition) {
        this.data.setAbsolutePosition(absolutePosition);
    }

    void setAngularSpeed(@NotNull Integer angularSpeed) {
        this.data.setAngularSpeed(angularSpeed);
    }

    KeyboardNumberInput<Integer> getAngularSpeedIntegerKeypad(@Nullable Integer initialSpeed) {
        KeyboardInputFactory keyboardFactory = this.userInteraction.getKeyboardInputFactory();
        InputValidationFactory validationFactory = this.userInteraction.getInputValidationFactory();
        InputValidator validator = validationFactory.createIntegerRangeValidator(this.data.minAllowedRPM().intValue(), this.data.maxAllowedRPM().intValue());
        KeyboardNumberInput keyboard = keyboardFactory.createIntegerKeypadInput();
        keyboard.setInitialValue((Object)initialSpeed);
        keyboard.setErrorValidator(validator);
        return keyboard;
    }

    UnitKeypad<Integer, Length> getScrewLengthIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(this.unitKeypadFactory.createIntegerRangeValidator(Length.class, this.data.minAllowedScrewLength(), this.data.maxAllowedScrewLength()));
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Length> getScrewLengthDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        UnitRangeValidator<Double, Length> validator = this.unitKeypadFactory.createDoubleRangeValidator(Length.class, this.data.minAllowedScrewLength(), this.data.maxAllowedScrewLength());
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(validator);
        return keypad;
    }
}

