/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.feeder;

import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.util.Compare;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.UUID;

public class Feeder {
    private final UUID id;
    private String name;
    private static boolean isInitialized;
    private Length screwLength;
    private static final Double DEFAULT_SCREW_LENGTH_MM;
    private static Length defaultScrewLength;
    private static final Double MIN_SCREW_LENGTH_MM;
    private static Length minScrewLength;
    private static final Double MAX_SCREW_LENGTH_MM;
    private static Length maxScrewLength;
    private static final Double WARN_LOW_SCREW_LENGTH_MM;
    private static Length warnLowScrewLength;
    private Length offset;
    private static final Double DEFAULT_OFFSET_MM;
    private static Length defaultOffset;
    private static final Double MIN_OFFSET_MM;
    private static Length minOffset;
    private static final Double MAX_OFFSET_MM;
    private static Length maxOffset;
    private static final Double WARN_LOW_OFFSET_MM;
    private static Length warnLowOffset;
    private Speed speed;
    private static final Double DEFAULT_SPEED_MM_S;
    private static Speed defaultSpeed;
    private static final Double MIN_SPEED_MM_S;
    private static Speed minSpeed;
    private static final Double MAX_SPEED_MM_S;
    private static Speed maxSpeed;
    private int retriesCount;
    private static final int defaultRetriesCount = 3;
    private static final int minRetriesCount = 1;
    private static final int maxRetriesCount = 10;
    private Pose pose;

    public Feeder() {
        this(UUID.randomUUID());
    }

    public Feeder(UUID id) {
        this.id = id;
        this.offset = null;
        this.name = "";
        this.pose = null;
        this.retriesCount = 0;
        this.speed = null;
        this.screwLength = null;
    }

    public static Feeder feederFactory() {
        assert (isInitialized);
        Feeder feeder = new Feeder();
        feeder.name = LanguagePack.getTextResource().feederDefaultFeederName();
        feeder.retriesCount = 3;
        feeder.offset = defaultOffset;
        feeder.screwLength = defaultScrewLength;
        feeder.speed = defaultSpeed;
        return feeder;
    }

    public static void init(SimpleValueFactory valueFactory) {
        defaultScrewLength = valueFactory.createLength(DEFAULT_SCREW_LENGTH_MM.doubleValue(), Length.Unit.MM);
        minScrewLength = valueFactory.createLength(MIN_SCREW_LENGTH_MM.doubleValue(), Length.Unit.MM);
        maxScrewLength = valueFactory.createLength(MAX_SCREW_LENGTH_MM.doubleValue(), Length.Unit.MM);
        defaultOffset = valueFactory.createLength(DEFAULT_OFFSET_MM.doubleValue(), Length.Unit.MM);
        minOffset = valueFactory.createLength(MIN_OFFSET_MM.doubleValue(), Length.Unit.MM);
        maxOffset = valueFactory.createLength(MAX_OFFSET_MM.doubleValue(), Length.Unit.MM);
        defaultSpeed = valueFactory.createSpeed(DEFAULT_SPEED_MM_S.doubleValue(), Speed.Unit.MM_S);
        minSpeed = valueFactory.createSpeed(MIN_SPEED_MM_S.doubleValue(), Speed.Unit.MM_S);
        maxSpeed = valueFactory.createSpeed(MAX_SPEED_MM_S.doubleValue(), Speed.Unit.MM_S);
        warnLowScrewLength = valueFactory.createLength(WARN_LOW_SCREW_LENGTH_MM.doubleValue(), Length.Unit.MM);
        warnLowOffset = valueFactory.createLength(WARN_LOW_OFFSET_MM.doubleValue(), Length.Unit.MM);
        isInitialized = true;
    }

    public String toString() {
        return this.name;
    }

    public boolean isFeederValid() {
        return this.pose != null && Feeder.screwLengthIsValid(this.screwLength) && Feeder.offSetIsValid(this.offset) && Feeder.speedIsValid(this.speed) && Feeder.retriesCountIsValid(this.retriesCount);
    }

    public static boolean screwLengthIsValid(Length screwLength) {
        return Compare.epsilonLessThan(minScrewLength, screwLength) && Compare.epsilonLessThanOrEquals(screwLength, maxScrewLength);
    }

    public static boolean offSetIsValid(Length offset) {
        return Compare.epsilonLessThanOrEquals(minOffset, offset) && Compare.epsilonLessThanOrEquals(offset, maxOffset);
    }

    public static boolean speedIsValid(Speed speed) {
        return Compare.epsilonLessThanOrEquals(minSpeed, speed) && Compare.epsilonLessThanOrEquals(speed, maxSpeed);
    }

    public static boolean retriesCountIsValid(int retriesCount) {
        return 1 <= retriesCount && retriesCount <= 10;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pose getPose() {
        return this.pose;
    }

    public void setPose(Pose pose) {
        this.pose = pose;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public void setRetriesCount(int retriesCount) {
        this.retriesCount = retriesCount;
    }

    public Length getOffset() {
        return this.offset;
    }

    public void setOffset(Length offset) {
        this.offset = offset;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public void setSpeed(Speed speed) {
        this.speed = speed;
    }

    public Length getScrewLength() {
        return this.screwLength;
    }

    public void setScrewLength(Length screwLength) {
        this.screwLength = screwLength;
    }

    public static Length getMinScrewLength() {
        return minScrewLength;
    }

    public static Length getMaxScrewLength() {
        return maxScrewLength;
    }

    public static Length getMinOffset() {
        return minOffset;
    }

    public static Length getMaxOffset() {
        return maxOffset;
    }

    public static Speed getMinSpeed() {
        return minSpeed;
    }

    public static Speed getMaxSpeed() {
        return maxSpeed;
    }

    public static Length getWarnLowScrewLength() {
        return warnLowScrewLength;
    }

    public static Length getWarnLowOffset() {
        return warnLowOffset;
    }

    public static int getMinRetriesCount() {
        return 1;
    }

    public static int getMaxRetriesCount() {
        return 10;
    }

    static {
        DEFAULT_SCREW_LENGTH_MM = 0.0;
        defaultScrewLength = null;
        MIN_SCREW_LENGTH_MM = 0.0;
        minScrewLength = null;
        MAX_SCREW_LENGTH_MM = 40.0;
        maxScrewLength = null;
        WARN_LOW_SCREW_LENGTH_MM = 5.0;
        warnLowScrewLength = null;
        DEFAULT_OFFSET_MM = 60.0;
        defaultOffset = null;
        MIN_OFFSET_MM = 16.0;
        minOffset = null;
        MAX_OFFSET_MM = 500.0;
        maxOffset = null;
        WARN_LOW_OFFSET_MM = 60.0;
        warnLowOffset = null;
        DEFAULT_SPEED_MM_S = 50.0;
        defaultSpeed = null;
        MIN_SPEED_MM_S = 25.0;
        minSpeed = null;
        MAX_SPEED_MM_S = 250.0;
        maxSpeed = null;
    }
}

