/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.localization.UnitsResource;
import com.spin.urcap.impl.program_nodes.InsertScrewProgramNodeView;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.Product;
import com.spin.urcap.impl.util.ScrewProgram;
import com.spin.urcap.impl.util.Tool;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.util.Filter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.robotposition.PositionParameters;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;

public class InsertScrewProgramNodeContribution
implements ProgramNodeContribution {
    private static final double DEF_S1_OFFSET_MIN = 6.0;
    private static final double DEF_S1_OFFSET_MAX = 16.0;
    private static final double DEF_S1_OFFSET_DEFAULT = 6.0;
    private static final double DEF_S1_OFFSET_WARNING = 6.0;
    private static final double DEF_S2_OFFSET_DEFAULT = 50.0;
    private static final double DEF_VEL_MAX_MIN = 1.0;
    private static final double DEF_VEL_MAX_MAX = 250.0;
    private static final double DEF_VEL_MAX_DEFAULT = 100.0;
    private static final double DEF_FORCE_IN_TCP_Z_DEFAULT = 10.0;
    private static final double MM_TO_M = 0.001;
    private static final long MODBUS_WAIT_TIME = 20L;
    private static final String KEY_FORCE_IN_TCP_Z = "KEY_FORCE_IN_TCP_Z";
    private static final String KEY_ENABLE_SAFETY = "KEY_ENABLE_SAFETY";
    private static final String KEY_POSE = "KEY_POSE";
    private static final String KEY_OFFSET_S1 = "KEY_OFFSET_S1";
    private static final String KEY_OFFSET_S2 = "KEY_OFFSET_S2";
    private static final String KEY_VEL_MAX = "KEY_VEL_MAX";
    private static final String KEY_CHECK_BOX_EXTERNAL_TARGET = "KEY_CHECK_BOX_EXTERNAL_TARGET";
    private static final String KEY_SPIN_TARGET = "spin_target";
    private static final String KEY_SELECTED_PRODUCT_ID = "KEY_SELECTED_PRODUCT_ID";
    private static final String KEY_SELECTED_PRODUCT_NAME = "KEY_SELECTED_PRODUCT_NAME";
    private static final String KEY_SELECTED_PRODUCT_SCREW_PROGRAM_IDS = "KEY_SELECTED_PRODUCT_SCREW_PROGRAM_IDS";
    private static final String KEY_SELECTED_SCREW_PROGRAM_ID = "KEY_SELECTED_SCREW_PROGRAM_ID";
    private static final String KEY_SELECTED_SCREW_PROGRAM_DIRECTION = "KEY_SELECTED_SCREW_PROGRAM_DIRECTION";
    private static final String KEY_SELECTED_SCREW_PROGRAM_NAME = "KEY_SELECTED_SCREW_PROGRAM_NAME";
    private static final String KEY_SELECTED_SCREW_PROGRAM_SCREW_LENGTH = "KEY_SELECTED_SCREW_PROGRAM_SCREW_LENGTH";
    private static final String KEY_SELECTED_SCREW_PROGRAM_SCREW_TYPE_ID = "KEY_SELECTED_SCREW_PROGRAM_SCREW_TYPE_ID";
    private static final String KEY_SELECTED_SCREW_PROGRAM_SCREW_WASHER_THICKNESS = "KEY_SELECTED_SCREW_PROGRAM_SCREW_WASHER_THICKNESS";
    private static final String KEY_SELECTED_SCREW_PROGRAM_TARGET_ANGLE = "KEY_SELECTED_SCREW_PROGRAM_TARGET_ANGLE";
    private static final String KEY_SELECTED_SCREW_PROGRAM_TARGET_POSITION = "KEY_SELECTED_SCREW_PROGRAM_TARGET_POSITION";
    private static final String KEY_SELECTED_SCREW_PROGRAM_TARGET_TORQUE = "KEY_SELECTED_SCREW_PROGRAM_TARGET_TORQUE";
    private static final String KEY_SELECTED_SCREW_PROGRAM_TARGET_DEV = "KEY_SELECTED_SCREW_PROGRAM_TARGET_DEV";
    private static final String KEY_SELECTED_SCREW_PROGRAM_TYPE_ID = "KEY_SELECTED_SCREW_PROGRAM_TYPE_ID";
    private static final String KEY_SELECTED_SCREW_PROGRAM_PARENT_ID = "KEY_SELECTED_SCREW_PROGRAM_PARENT_ID";
    private static final String KEY_SELECTED_SCREW_PROGRAM_CHILD_ID = "KEY_SELECTED_SCREW_PROGRAM_CHILD_ID";
    private final ProgramAPI programAPI;
    private final ProgramModel programModel;
    private final ProgramAPIProvider programAPIProvider;
    private final InsertScrewProgramNodeView view;
    private final LanguagePack languagePack;
    private final KeyboardInputFactory keyboardFactory;
    private final RobotMovement robotMovement;
    private final ProgramNodeFactory programNodeFactory;
    private final KeyboardInputFactory keyboardFactoryForceInTCPZ;
    public final DataModel model;
    private final Localization localization;

    InsertScrewProgramNodeContribution(ProgramAPIProvider apiProvider, InsertScrewProgramNodeView view, DataModel model) {
        this.programAPIProvider = apiProvider;
        this.programAPI = apiProvider.getProgramAPI();
        this.programModel = apiProvider.getProgramAPI().getProgramModel();
        this.model = model;
        this.view = view;
        this.keyboardFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.keyboardFactoryForceInTCPZ = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.programNodeFactory = apiProvider.getProgramAPI().getProgramModel().getProgramNodeFactory();
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.localization = apiProvider.getSystemAPI().getSystemSettings().getLocalization();
        this.robotMovement = apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement();
        try {
            Collection collection = apiProvider.getProgramAPI().getVariableModel().get((Filter)new Filter<Variable>(){

                public boolean accept(Variable element) {
                    return element.getDisplayName().equals(InsertScrewProgramNodeContribution.KEY_SPIN_TARGET);
                }
            });
            if (collection.toArray().length == 0) {
                VariableFactory variableFactory = this.programAPI.getVariableModel().getVariableFactory();
                ExpressionBuilder expressionBuilder = this.programAPI.getValueFactoryProvider().createExpressionBuilder();
                Expression expression = expressionBuilder.append("get_actual_tcp_pose()").build();
                this.model.set(KEY_SPIN_TARGET, (Variable)variableFactory.createGlobalVariable(KEY_SPIN_TARGET, expression));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openView() {
        this.updateProductComboBox();
        this.view.setSelectedProduct(this.getSelectedProduct());
        this.view.setSelectedScrewProgram(this.getSelectedScrewProgram());
        this.view.setSetPoseBtn(this.getTextResource().setPos2BtnProgramPick());
        this.view.setMoveHereBtnText(this.getTextResource().insertScrewVerifyPos());
        this.view.setS1OffSetLabel(this.getTextResource().loadScrewOffset());
        this.view.setS2offSetLabel(this.getTextResource().loadScrewOffset2());
        this.view.setMaxVelocityLabel(this.getTextResource().loadScrewSpeed());
        this.view.setS1Offset(this.model.get(KEY_OFFSET_S1, String.valueOf(6.0)));
        this.view.setS2Offset(this.model.get(KEY_OFFSET_S2, String.valueOf(50.0)));
        this.view.setMaxVelocity(this.model.get(KEY_VEL_MAX, String.valueOf(100.0)));
        if (Double.parseDouble(this.model.get(KEY_OFFSET_S1, String.valueOf(6.0))) > 6.0) {
            this.view.setS1OffsetIconWarning();
        } else {
            this.view.setS1OffsetIconNoWarning();
        }
        if (this.getUnitType().equals((Object)UnitType.METRIC)) {
            this.view.setS1OffSetUnitLabel(this.getUnitResource().UNIT_mm());
            this.view.setS2offSetUnitLabel(this.getUnitResource().UNIT_mm());
            this.view.setMaxVelocityUnitLabel(this.getUnitResource().UNIT_velocityM());
        } else {
            this.view.setS1OffSetUnitLabel(this.getUnitResource().UNIT_ft());
            this.view.setS2offSetUnitLabel(this.getUnitResource().UNIT_ft());
            this.view.setMaxVelocityUnitLabel(this.getUnitResource().UNIT_velocityI());
        }
        this.view.setForceInTCPZUnitLabel(this.getUnitResource().UNIT_Newton());
        this.view.setForceInTCPZLabel(this.getTextResource().loadScrewForce());
        this.model.set(KEY_FORCE_IN_TCP_Z, 10.0);
        this.view.setForceInTCPZ(this.model.get(KEY_FORCE_IN_TCP_Z, String.valueOf(10.0)));
        this.view.enableMoveBtn(this.model.get("KEY_BUTTON_VERIFY_INSERTION_POSITION_ENABLED", false) && !this.model.get(KEY_CHECK_BOX_EXTERNAL_TARGET, false));
        this.view.setCkBoxExternalTarget(this.model.get(KEY_CHECK_BOX_EXTERNAL_TARGET, false));
        this.view.enableSetPoseBtn(!this.model.get(KEY_CHECK_BOX_EXTERNAL_TARGET, false));
        Timer uiTimer = new Timer(true);
        uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
            }
        }, 0L, 500L);
        this.createScrewdrivingNode();
    }

    public void closeView() {
        this.view.setPanelsVisible();
    }

    public UnitType getUnitType() {
        return this.localization.getUnitType();
    }

    private UnitsResource getUnitResource() {
        return this.languagePack.getUnitsResource();
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    public String getTitle() {
        return this.getTextResource().insertScrewTitle() + ": " + this.model.get(KEY_SELECTED_SCREW_PROGRAM_NAME, this.getTextResource().insertScrewSelectScrewProgram());
    }

    public boolean isDefined() {
        return this.model.isSet(KEY_SELECTED_PRODUCT_ID) && this.model.isSet(KEY_SELECTED_SCREW_PROGRAM_ID) && (this.model.get(KEY_CHECK_BOX_EXTERNAL_TARGET, false) || this.model.isSet(KEY_POSE));
    }

    public void generateScript(ScriptWriter scriptWriter) {
        ScrewProgram screwProgram = this.getSelectedScrewProgram();
        if (screwProgram == null) {
            return;
        }
        if (screwProgram.typeId == 3) {
            try {
                XMLRPCClient xmlrpcClient = new XMLRPCClient();
                if (xmlrpcClient.isConnected().booleanValue()) {
                    Tool toolLimits = xmlrpcClient.getTool();
                    System.out.println("Tool limits: " + toolLimits.toString());
                    if (toolLimits.motor.minTorque > screwProgram.targetTorque || toolLimits.motor.maxTorque < screwProgram.targetTorque) {
                        scriptWriter.appendLine("popup(\"The torque target of the screw program is out of range for the tool. The tools torque range is " + toolLimits.motor.minTorque + " to " + toolLimits.motor.maxTorque + " Nm and the target torque is " + screwProgram.targetTorque + " Nm. \", title=\"Torque out of range \", warning=True, blocking=True)");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Screw program: " + screwProgram.toStringComplete());
        double offsetS1 = this.model.get(KEY_OFFSET_S1, 6.0) * 0.001;
        scriptWriter.appendLine("spin_check_and_reset_tool()");
        scriptWriter.appendLine("global screwProgramId = " + screwProgram.id);
        scriptWriter.appendLine("global robotStartOffset = " + offsetS1);
        scriptWriter.appendLine("global typeId = " + screwProgram.typeId);
        scriptWriter.appendLine("force_mode_set_damping(1)");
        scriptWriter.appendLine((screwProgram.typeId == 1 ? "spin_approach_screw_extraction" : "spin_approach_screw_insertion") + "(" + (this.model.get(KEY_CHECK_BOX_EXTERNAL_TARGET, false) ? KEY_SPIN_TARGET : this.model.get(KEY_POSE, (Pose)null)) + "," + offsetS1 + "," + this.model.get(KEY_OFFSET_S2, 50.0) * 0.001 + "," + this.model.get(KEY_VEL_MAX, 100.0) * 0.001 + "," + screwProgram.screw.length + "," + this.getForceInZAxis() + "," + (this.view.getEnableSafety() ? "True" : "False") + "," + screwProgram.direction + ")");
        scriptWriter.writeChildren();
        scriptWriter.appendLine("force_mode_set_damping(0.005) # Reset default damping");
    }

    public KeyboardNumberInput<Double> getKeyboardForForceInTCPZ() {
        KeyboardNumberInput keyboardInput = this.keyboardFactoryForceInTCPZ.createDoubleKeypadInput();
        if (this.view.getForceInTCPZ().isEmpty()) {
            keyboardInput.setInitialValue((Object)0.0);
        } else {
            keyboardInput.setInitialValue((Object)Double.parseDouble(this.view.getForceInTCPZ()));
        }
        return keyboardInput;
    }

    public KeyboardInputCallback<Double> getCallbackForForceInTCPZ() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                InsertScrewProgramNodeContribution.this.view.setForceInTCPZ(Double.toString(value));
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_FORCE_IN_TCP_Z, value.doubleValue());
            }
        };
    }

    public KeyboardNumberInput<Double> getKeyboardForS1() {
        KeyboardNumberInput keyboard = this.keyboardFactory.createDoubleKeypadInput();
        if (this.view.getS1Offset().isEmpty()) {
            keyboard.setInitialValue((Object)6.0);
        } else {
            keyboard.setInitialValue((Object)Double.parseDouble(this.view.getS1Offset()));
        }
        return keyboard;
    }

    public KeyboardInputCallback<Double> getCallbackForS1() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                if (value >= 16.0) {
                    PopupTool.showDialogWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS1LargerThanMax(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS1LargerThanMaxTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                    InsertScrewProgramNodeContribution.this.view.setS1Offset(Double.toString(16.0));
                    InsertScrewProgramNodeContribution.this.view.setS1OffsetIconWarning();
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 16.0);
                } else if (value > 6.0) {
                    if (PopupTool.showDialogOptionWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewOffsetHighWarning(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewOffsetHighWarningTitle(), InsertScrewProgramNodeContribution.this.getTextResource().optionNo(), InsertScrewProgramNodeContribution.this.getTextResource().optionYes(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png")))) > 0) {
                        InsertScrewProgramNodeContribution.this.view.setS1Offset(Double.toString(value));
                        InsertScrewProgramNodeContribution.this.view.setS1OffsetIconWarning();
                        InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, value.doubleValue());
                    } else {
                        InsertScrewProgramNodeContribution.this.view.setS1Offset(Double.toString(6.0));
                        InsertScrewProgramNodeContribution.this.view.setS1OffsetIconNoWarning();
                        InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 6.0);
                    }
                } else if (value < 6.0) {
                    PopupTool.showDialogWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewOffsetSmallWarning(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewOffsetSmallWarningTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                    InsertScrewProgramNodeContribution.this.view.setS1Offset(Double.toString(6.0));
                    InsertScrewProgramNodeContribution.this.view.setS1OffsetIconNoWarning();
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 6.0);
                } else {
                    InsertScrewProgramNodeContribution.this.view.setS1Offset(Double.toString(value));
                    InsertScrewProgramNodeContribution.this.view.setS1OffsetIconNoWarning();
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, value.doubleValue());
                }
                if (value > InsertScrewProgramNodeContribution.this.model.get(InsertScrewProgramNodeContribution.KEY_OFFSET_S2, 50.0)) {
                    PopupTool.showDialogWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS1LargerThanS2Warning(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS1LargerThanS2WarningTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                    InsertScrewProgramNodeContribution.this.view.setS2Offset(Double.toString(value));
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S2, value.doubleValue());
                }
            }
        };
    }

    public KeyboardNumberInput<Double> getKeyboardForS2() {
        KeyboardNumberInput keyboard = this.keyboardFactory.createDoubleKeypadInput();
        if (this.view.getS2Offset().isEmpty()) {
            keyboard.setInitialValue((Object)50.0);
        } else {
            keyboard.setInitialValue((Object)Double.parseDouble(this.view.getS2Offset()));
        }
        return keyboard;
    }

    public KeyboardInputCallback<Double> getCallbackForS2() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                if (value < InsertScrewProgramNodeContribution.this.model.get(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 6.0)) {
                    PopupTool.showDialogWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS2SmallerThanS1Warning(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewS2SmallerThanS1WarningTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                    InsertScrewProgramNodeContribution.this.view.setS2Offset(Double.toString(InsertScrewProgramNodeContribution.this.model.get(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 6.0)));
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S2, InsertScrewProgramNodeContribution.this.model.get(InsertScrewProgramNodeContribution.KEY_OFFSET_S1, 6.0));
                } else {
                    InsertScrewProgramNodeContribution.this.view.setS2Offset(Double.toString(value));
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_OFFSET_S2, value.doubleValue());
                }
            }
        };
    }

    public KeyboardNumberInput<Double> getKeyboardVelocity() {
        KeyboardNumberInput keyboard = this.keyboardFactory.createPositiveDoubleKeypadInput();
        keyboard.setInitialValue((Object)this.model.get(KEY_VEL_MAX, 100.0));
        return keyboard;
    }

    public KeyboardInputCallback<Double> getCallbackVelocity() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                if (1.0 < value && value < 250.0) {
                    InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_VEL_MAX, value.doubleValue());
                    InsertScrewProgramNodeContribution.this.view.setMaxVelocity(Double.toString(value));
                } else {
                    PopupTool.showDialogWarning(InsertScrewProgramNodeContribution.this.getTextResource().insertScrewVelocityWarning(), InsertScrewProgramNodeContribution.this.getTextResource().insertScrewVelocityWarningTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                }
            }
        };
    }

    public void safetySettingsChanged(final boolean safety_enabled) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_ENABLE_SAFETY, safety_enabled);
            }
        });
    }

    public void setCheckBoxExternalTarget(final boolean bool) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_CHECK_BOX_EXTERNAL_TARGET, bool);
            }
        });
    }

    public void selectPose() {
        this.clearErrors();
        this.programAPIProvider.getUserInterfaceAPI().getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback2(){

            public void onOk(PositionParameters parameters) {
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_POSE, parameters.getPose());
                InsertScrewProgramNodeContribution.this.view.enableMoveBtn(true);
                InsertScrewProgramNodeContribution.this.model.set("KEY_BUTTON_VERIFY_INSERTION_POSITION_ENABLED", true);
            }
        });
    }

    public void moveRobot() {
        this.clearErrors();
        Pose centerPose = this.model.get(KEY_POSE, (Pose)null);
        if (centerPose != null) {
            this.robotMovement.requestUserToMoveRobot(centerPose, new RobotMovementCallback(){

                public void onComplete(MovementCompleteEvent event) {
                }

                public void onError(MovementErrorEvent event) {
                    InsertScrewProgramNodeContribution.this.updateError(new RobotState(InsertScrewProgramNodeContribution.this.getErrorMessage(event.getErrorType())));
                }
            });
        }
    }

    private void setErrorPopup(String message, String title) {
        PopupTool.showDialogError(message, title);
    }

    private void updateError(RobotState robotState) {
        this.setErrorPopup(robotState.getMessage(), this.getTextResource().generalErrorMsg());
    }

    private void clearErrors() {
    }

    private String getErrorMessage(MovementErrorEvent.ErrorType errorType) {
        if (errorType == MovementErrorEvent.ErrorType.UNREACHABLE_POSE) {
            return this.getTextResource().moveErrorNotToPositionText();
        }
        return this.getTextResource().moveErrorText();
    }

    public Product getSelectedProduct() {
        if (!this.model.isSet(KEY_SELECTED_PRODUCT_ID)) {
            return null;
        }
        Product product = new Product();
        product.id = this.model.get(KEY_SELECTED_PRODUCT_ID, -1);
        product.name = this.model.get(KEY_SELECTED_PRODUCT_NAME, "");
        product.screwProgramIds = this.model.get(KEY_SELECTED_PRODUCT_SCREW_PROGRAM_IDS, new int[0]);
        return product;
    }

    public void setSelectedProduct(final Product product) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_PRODUCT_ID, product.id);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_PRODUCT_NAME, product.name);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_PRODUCT_SCREW_PROGRAM_IDS, product.screwProgramIds);
            }
        });
    }

    public int[] getProductIds() {
        try {
            XMLRPCClient xmlrpcClient = new XMLRPCClient();
            if (!xmlrpcClient.isConnected().booleanValue()) {
                return new int[0];
            }
            return xmlrpcClient.getProductIds();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product[] getProducts(int[] productIds) {
        try {
            XMLRPCClient xmlrpcClient = new XMLRPCClient();
            if (!xmlrpcClient.isConnected().booleanValue()) {
                return new Product[0];
            }
            Product[] res = new Product[productIds.length];
            for (int i = 0; i < productIds.length; ++i) {
                xmlrpcClient.setGetProduct(productIds[i]);
                InsertScrewProgramNodeContribution insertScrewProgramNodeContribution = this;
                synchronized (insertScrewProgramNodeContribution) {
                    this.wait(20L);
                }
                res[i] = xmlrpcClient.getProduct();
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Product[0];
        }
    }

    private void updateProductComboBox() {
        int[] productIds = this.getProductIds();
        Product[] products = this.getProducts(productIds);
        this.view.updateProductComboBox(products);
    }

    public ScrewProgram getSelectedScrewProgram() {
        if (!this.model.isSet(KEY_SELECTED_SCREW_PROGRAM_ID)) {
            return null;
        }
        ScrewProgram screwProgram = new ScrewProgram();
        screwProgram.id = this.model.get(KEY_SELECTED_SCREW_PROGRAM_ID, -1);
        screwProgram.name = this.model.get(KEY_SELECTED_SCREW_PROGRAM_NAME, "");
        screwProgram.direction = this.model.get(KEY_SELECTED_SCREW_PROGRAM_DIRECTION, -1);
        screwProgram.childId = this.model.get(KEY_SELECTED_SCREW_PROGRAM_CHILD_ID, -1);
        screwProgram.parentId = this.model.get(KEY_SELECTED_SCREW_PROGRAM_PARENT_ID, -1);
        screwProgram.typeId = this.model.get(KEY_SELECTED_SCREW_PROGRAM_TYPE_ID, -1);
        screwProgram.screw.length = this.model.get(KEY_SELECTED_SCREW_PROGRAM_SCREW_LENGTH, -1.0);
        screwProgram.screw.typeId = this.model.get(KEY_SELECTED_SCREW_PROGRAM_SCREW_TYPE_ID, -1);
        screwProgram.screw.washerThickness = this.model.get(KEY_SELECTED_SCREW_PROGRAM_SCREW_WASHER_THICKNESS, -1.0);
        screwProgram.targetAngle = this.model.get(KEY_SELECTED_SCREW_PROGRAM_TARGET_ANGLE, -1.0);
        screwProgram.targetPosition = this.model.get(KEY_SELECTED_SCREW_PROGRAM_TARGET_POSITION, -1.0);
        screwProgram.targetTorque = this.model.get(KEY_SELECTED_SCREW_PROGRAM_TARGET_TORQUE, -1.0);
        screwProgram.targetDev = this.model.get(KEY_SELECTED_SCREW_PROGRAM_TARGET_DEV, -1.0);
        return screwProgram;
    }

    public void setSelectedScrewProgram(final ScrewProgram screwProgram) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_ID, screwProgram.id);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_NAME, screwProgram.name);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_DIRECTION, screwProgram.direction);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_CHILD_ID, screwProgram.childId);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_PARENT_ID, screwProgram.parentId);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_TYPE_ID, screwProgram.typeId);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_SCREW_LENGTH, screwProgram.screw.length);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_SCREW_TYPE_ID, screwProgram.screw.typeId);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_SCREW_WASHER_THICKNESS, screwProgram.screw.washerThickness);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_TARGET_ANGLE, screwProgram.targetAngle);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_TARGET_POSITION, screwProgram.targetPosition);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_TARGET_TORQUE, screwProgram.targetTorque);
                InsertScrewProgramNodeContribution.this.model.set(InsertScrewProgramNodeContribution.KEY_SELECTED_SCREW_PROGRAM_TARGET_DEV, screwProgram.targetDev);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrewProgram[] getScrewPrograms(int[] screwProgramIds) {
        try {
            XMLRPCClient xmlrpcClient = new XMLRPCClient();
            if (!xmlrpcClient.isConnected().booleanValue()) {
                return new ScrewProgram[0];
            }
            ScrewProgram[] screwPrograms = new ScrewProgram[screwProgramIds.length];
            for (int i = 0; i < screwProgramIds.length; ++i) {
                xmlrpcClient.setGetScrewProgram(screwProgramIds[i]);
                InsertScrewProgramNodeContribution insertScrewProgramNodeContribution = this;
                synchronized (insertScrewProgramNodeContribution) {
                    this.wait(20L);
                }
                screwPrograms[i] = xmlrpcClient.getScrewProgram();
            }
            return screwPrograms;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ScrewProgram[0];
        }
    }

    public void updateScrewProgramComboBox() {
        Product selectedProduct = this.getSelectedProduct();
        if (selectedProduct == null) {
            return;
        }
        ScrewProgram[] screwPrograms = this.getScrewPrograms(selectedProduct.screwProgramIds);
        this.view.updateScrewProgramComboBox(screwPrograms);
    }

    private void createScrewdrivingNode() {
        try {
            if (this.programModel.getRootTreeNode((ProgramNodeContribution)this).getChildren().isEmpty()) {
                TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
                TreeNode screwdrivingTreeNode = rootTreeNode.addChild((ProgramNode)this.programNodeFactory.createScrewdrivingNode());
                rootTreeNode.setChildSequenceLocked(true);
                screwdrivingTreeNode.setChildSequenceLocked(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double getForceInZAxis() {
        return this.model.get(KEY_FORCE_IN_TCP_Z, 10.0);
    }

    private static class RobotState {
        private final String message;

        RobotState(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

