/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes.load_screw;

import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.simple.Force;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadScrewData {
    DataModel model;

    public LoadScrewData(DataModel model) {
        this.model = model;
    }

    public void saveSelectedFeederId(@Nullable UUID id) {
        String idString = id == null ? "null" : id.toString();
        this.model.set(LoadScrewKey.SELECTED_FEEDER.name(), idString);
    }

    @Nullable
    public UUID loadSelectedFeederId() {
        String idString = this.model.get(LoadScrewKey.SELECTED_FEEDER.name(), (String)null);
        if (Objects.equals(idString, "null") || idString == null) {
            return null;
        }
        return UUID.fromString(idString);
    }

    public void saveSafetyForce(@NotNull Force force) {
        this.model.set(LoadScrewKey.SAFETY_FORCE.name(), force);
    }

    @Nullable
    public Force loadSafetyForce() {
        return this.model.get(LoadScrewKey.SAFETY_FORCE.name(), (Force)null);
    }

    public void saveSafetyEnabled(boolean enabled) {
        this.model.set(LoadScrewKey.SAFETY_ENABLED.name(), enabled);
    }

    public boolean loadSafetyEnabled() {
        return this.model.get(LoadScrewKey.SAFETY_ENABLED.name(), true);
    }

    static enum LoadScrewKey {
        SAFETY_ENABLED,
        SAFETY_FORCE,
        SELECTED_FEEDER;

    }
}

