/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.xmlrpc;

import com.spin.urcap.impl.util.Bridge;
import com.spin.urcap.impl.util.Product;
import com.spin.urcap.impl.util.ScrewProgram;
import com.spin.urcap.impl.util.ScrewProgramLog;
import com.spin.urcap.impl.util.Tool;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;

public class XMLRPCClient
extends XmlRpcClient {
    private static final Lock mutex = new ReentrantLock();
    private static XmlRpcClient xmlRpcClient;

    public XMLRPCClient() throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL("http://127.0.0.1:40722/RPC2"));
        config.setEnabledForExtensions(true);
        xmlRpcClient = new XmlRpcClient();
        xmlRpcClient.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(xmlRpcClient));
        xmlRpcClient.setConfig((XmlRpcClientConfig)config);
    }

    public String getTitle() {
        mutex.lock();
        try {
            String string = (String)xmlRpcClient.execute("ModbusHandler.getTitle", new Vector(0));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error";
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    public String getIp() {
        mutex.lock();
        try {
            String string = (String)xmlRpcClient.execute("ModbusHandler.getIp", new Vector(0));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error";
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    public String getDHCP() {
        mutex.lock();
        try {
            String string = (String)xmlRpcClient.execute("ModbusHandler.getDHCP", new Vector(0));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error";
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean connect(String ip, int port) {
        mutex.lock();
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(ip);
            params.addElement(port);
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.connect", params);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean disconnect() {
        mutex.lock();
        try {
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.disconnect", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean isConnected() {
        mutex.lock();
        try {
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.isConnected", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public void handleConnected(boolean onConnected) {
        mutex.lock();
        try {
            Vector<Boolean> params = new Vector<Boolean>();
            params.addElement(onConnected);
            xmlRpcClient.execute("ModbusHandler.handleConnected", params);
        }
        catch (Exception e) {
            System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": handleConnected error.");
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean ping() {
        mutex.lock();
        try {
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.ping", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolBuzzerIntensity() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getToolBuzzerIntensity", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolLedIntensity() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getToolLedIntensity", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public String getConnectionError() {
        mutex.lock();
        try {
            String string = (String)xmlRpcClient.execute("ModbusHandler.getConnectionError", new Vector(0));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    public Tool getTool() {
        mutex.lock();
        try {
            Tool tool = (Tool)xmlRpcClient.execute("ModbusHandler.getTool", new Vector(0));
            return tool;
        }
        catch (Exception e) {
            e.printStackTrace();
            Tool tool = null;
            return tool;
        }
        finally {
            mutex.unlock();
        }
    }

    public Bridge getBridge() {
        mutex.lock();
        try {
            Bridge bridge = (Bridge)xmlRpcClient.execute("ModbusHandler.getBridge", new Vector(0));
            return bridge;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bridge bridge = null;
            return bridge;
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean getToolConnection() {
        mutex.lock();
        try {
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.getToolConnection", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolScrewState() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getToolScrewState", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolSafetyShieldState() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getToolSafetyShieldState", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getToolSafetyShieldPosition() {
        mutex.lock();
        try {
            double d = (Double)xmlRpcClient.execute("ModbusHandler.getToolSafetyShieldPosition", new Vector(0));
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            double d = -1.0;
            return d;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getToolButton1State() {
        mutex.lock();
        try {
            boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.getToolButton1State", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getToolButton2State() {
        mutex.lock();
        try {
            boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.getToolButton2State", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolScrewDetectionValue() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getToolScrewDetectionValue", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean getBridgeRobotInterfaceConnection() {
        mutex.lock();
        try {
            Boolean bl = (Boolean)xmlRpcClient.execute("ModbusHandler.getBridgeRobotInterfaceConnection", new Vector(0));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getBridgeScrewProcessState() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getBridgeScrewProcessState", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int[] getBridgeError() {
        mutex.lock();
        try {
            int[] nArray = (int[])xmlRpcClient.execute("ModbusHandler.getBridgeError", new Vector(0));
            return nArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            mutex.unlock();
        }
    }

    public String[] getBridgeErrorString() {
        mutex.lock();
        try {
            String[] stringArray = (String[])xmlRpcClient.execute("ModbusHandler.getBridgeErrorString", new Vector(0));
            return stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            mutex.unlock();
        }
    }

    public int[] getProductIds() {
        mutex.lock();
        try {
            int[] nArray = (int[])xmlRpcClient.execute("ModbusHandler.getProductIds", new Vector(0));
            return nArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            mutex.unlock();
        }
    }

    public Product getProduct() {
        mutex.lock();
        try {
            Product product = (Product)xmlRpcClient.execute("ModbusHandler.getProduct", new Vector(0));
            return product;
        }
        catch (Exception e) {
            e.printStackTrace();
            Product product = null;
            return product;
        }
        finally {
            mutex.unlock();
        }
    }

    public ScrewProgram getScrewProgram() {
        mutex.lock();
        try {
            ScrewProgram screwProgram = (ScrewProgram)xmlRpcClient.execute("ModbusHandler.getScrewProgram", new Vector(0));
            return screwProgram;
        }
        catch (Exception e) {
            e.printStackTrace();
            ScrewProgram screwProgram = null;
            return screwProgram;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getScrewProgramLogId() {
        mutex.lock();
        try {
            int n = (Integer)xmlRpcClient.execute("ModbusHandler.getScrewProgramLogId", new Vector(0));
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public ScrewProgramLog getScrewProgramLog() {
        mutex.lock();
        try {
            ScrewProgramLog screwProgramLog = (ScrewProgramLog)xmlRpcClient.execute("ModbusHandler.getScrewProgramLog", new Vector(0));
            return screwProgramLog;
        }
        catch (Exception e) {
            e.printStackTrace();
            ScrewProgramLog screwProgramLog = null;
            return screwProgramLog;
        }
        finally {
            mutex.unlock();
        }
    }

    public void setToolBuzzerIntensity(int data) {
        mutex.lock();
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(data);
            xmlRpcClient.execute("ModbusHandler.setToolBuzzerIntensity", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    public void setToolLedIntensity(int data) {
        mutex.lock();
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(data);
            xmlRpcClient.execute("ModbusHandler.setToolLedIntensity", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    public void setGetProduct(int data) {
        mutex.lock();
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(data);
            xmlRpcClient.execute("ModbusHandler.setGetProduct", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    public void setGetScrewProgram(int data) {
        mutex.lock();
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(data);
            xmlRpcClient.execute("ModbusHandler.setGetScrewProgram", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    public void setResetErrors() {
        mutex.lock();
        try {
            xmlRpcClient.execute("ModbusHandler.setResetErrors", new Vector(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSafetyShieldCommand(int command, double position, double speed) {
        mutex.lock();
        try {
            Vector<Number> params = new Vector<Number>();
            params.addElement(command);
            params.addElement(position);
            params.addElement(speed);
            xmlRpcClient.execute("ModbusHandler.setSafetyShieldCommand", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrewCommand(int command, int direction, int speed) {
        mutex.lock();
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(command);
            params.addElement(direction);
            params.addElement(speed);
            xmlRpcClient.execute("ModbusHandler.setScrewCommand", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrewProgramCommand(int command, int id, double robotStartOffset) {
        mutex.lock();
        try {
            Vector<Number> params = new Vector<Number>();
            params.addElement(command);
            params.addElement(id);
            params.addElement(robotStartOffset);
            xmlRpcClient.execute("ModbusHandler.setScrewProgramCommand", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mutex.unlock();
        }
    }
}

