/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.image;

import com.spin.ui.image.IconLoader;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public enum SpinImage {
    ATTACH_BIT("attach_bit.jpg"),
    DETACH_BIT("detach_bit.jpg"),
    BIT_CHANGING_STATION("bit_changing_station.png"),
    BIT_CHANGING_STATION_BIT_1("bit_changing_station_bit_1.png"),
    BIT_CHANGING_STATION_BIT_2("bit_changing_station_bit_2.png"),
    BIT_CHANGING_STATION_BIT_3("bit_changing_station_bit_3.png"),
    BIT_CHANGING_STATION_POINT_A("bit_changing_station_point_a.png"),
    BIT_CHANGING_STATION_POINT_B("bit_changing_station_point_b.png"),
    BIT_CHANGING_STATION_POINT_C("bit_changing_station_point_c.png"),
    SCREW_FEEDER("screw_feeder.jpg"),
    LOAD_SCREW("load_screw.jpg"),
    ROBOT("robot.png"),
    BRIDGE("bridge.png"),
    TOOL("tool.png"),
    TEACH_SCREW_POSITION("teach_screw.jpg"),
    SAFETY_CLEARANCE("safety_clearance.png"),
    TEACH_SCREW_GOOD_BAD("teach_screw_good_bad.png");

    private static final String BASE_PATH = "/images/";
    private final String fileName;

    private SpinImage(String fileName) {
        this.fileName = fileName;
    }

    @NotNull
    String fileName() {
        return this.fileName;
    }

    @NotNull
    public ImageIcon load() {
        String path = BASE_PATH + this.fileName;
        return IconLoader.load(path);
    }

    @NotNull
    public ImageIcon load(@NotNull Dimension dimension) {
        String path = BASE_PATH + this.fileName;
        return IconLoader.load(path, dimension);
    }
}

