/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_fault;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionInterface;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionService;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultInterface;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultText;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.util.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class OnFaultContribution
implements ProgramNodeContribution,
OnFaultInterface {
    @NotNull
    private final String nodeTitle;

    OnFaultContribution(@NotNull ExtendedProgramAPIProvider apiProvider, CreationContext.NodeCreationType nodeCreationType) {
        this.nodeTitle = apiProvider.getTextResource().load(OnFaultText.ON_FAULT);
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnFaultContribution.buildSubTree(apiProvider, this);
        }
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnFaultContribution contribution) {
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory programNodeFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        SimpleValueFactory valueFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        try {
            OnFaultContribution.addMoveAwayNode(rootNode, programNodeFactory, valueFactory);
            OnFaultContribution.addSafetyShieldCoverBitNode(rootNode, programNodeFactory);
        }
        catch (TreeStructureException e) {
            SpinLog.print("Cannot add child nodes to onFault node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void addMoveAwayNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull SimpleValueFactory valueFactory) throws TreeStructureException {
        URCapProgramNode moveNode = programNodeFactory.createURCapProgramNode(MoveDirectionService.class);
        rootNode.addChild((ProgramNode)moveNode);
        ((MoveDirectionInterface)moveNode.getAs(MoveDirectionInterface.class)).setMoveDistance(valueFactory.createLength(50.0, Length.Unit.MM));
    }

    private static void addSafetyShieldCoverBitNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        rootNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        writer.appendLine("elif (screw_status == 3) :");
        writer.appendLine("sync()");
        writer.writeChildren();
        writer.appendLine("popup(error_message, error_title, error = True, blocking=True)");
        writer.appendLine("halt");
        writer.appendLine("end");
    }

    @Override
    public void writeTheScript(@NotNull ScriptWriter writer) {
        this.generateScript(writer);
    }
}

