/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.handler;

import com.spin.bridge_communication.URCapInterfaceProvider;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.program_data.ProgramDataConsumer;
import com.spin.bridge_communication.proxy.monitorer.StateHandler;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import com.spin.bridge_communication.result.ResultConsumer;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusListener;
import com.spin.domain.BridgeInfo;
import com.spin.domain.MonitoredItems;
import com.spin.domain.Part;
import com.spin.domain.ProgramResult;
import com.spin.domain.ToolInfo;
import com.spin.util.Action;
import com.spin.util.SpinLog;
import com.spin.util.ToggleAction;
import com.ur.urcap.api.domain.io.DigitalIO;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;

public class StateHandlerImpl
implements StateHandler {
    private static final String nilUUID = "00000000-0000-0000-0000-000000000000";
    @NotNull
    private final XmlRpcBridgeClient bridgeClient;
    @NotNull
    private final BridgeConnectionStatusListener bridgeConnectionListener;
    @NotNull
    private final DigitalIO freedriveOutput;
    @NotNull
    private final DigitalIO frontButtonOutput;
    @NotNull
    private final ToggleAction toolConnectionAction;
    @NotNull
    private final ProgramDataConsumer programDataConsumer;
    @NotNull
    private final ResultConsumer resultConsumer;
    private int lastProgramDataID = -1;
    @NotNull
    private String lastResultUUID = "00000000-0000-0000-0000-000000000000";

    public StateHandlerImpl(@NotNull XmlRpcBridgeClient bridgeClient, @NotNull URCapInterfaceProvider interfaceProvider, @NotNull DigitalIO freedriveOutput, @NotNull DigitalIO frontButtonOutput) {
        this.bridgeClient = bridgeClient;
        this.bridgeConnectionListener = interfaceProvider.getBridgeConnectionStatusListener();
        this.freedriveOutput = freedriveOutput;
        this.frontButtonOutput = frontButtonOutput;
        this.toolConnectionAction = StateHandlerImpl.createToolConnectionAction(bridgeClient, interfaceProvider.getToolConnectionStatusListener());
        this.programDataConsumer = interfaceProvider.getProgramDataConsumer();
        this.resultConsumer = interfaceProvider.getResultConsumer();
    }

    @NotNull
    private static ToggleAction createToolConnectionAction(@NotNull XmlRpcBridgeClient bridgeClient, @NotNull ToolConnectionStatusListener toolConnectionListener) {
        Action forwardToolInfoToListeners = () -> {
            try {
                ToolInfo info = bridgeClient.toolInfo();
                toolConnectionListener.onConnected(info);
            }
            catch (XmlRpcException e) {
                SpinLog.print("XmlRpcException while reading tool info: " + e.getMessage());
                throw new Action.AbortAction();
            }
        };
        return new ToggleAction.Builder().doWhenToggledToTrue(forwardToolInfoToListeners).doWhenToggledToFalse(toolConnectionListener::onDisconnected).buildWithInitialState(false);
    }

    @Override
    public void handleBridgeConnected() throws XmlRpcException {
        BridgeInfo bridgeInfo = this.bridgeClient.bridgeInfo();
        this.bridgeConnectionListener.onConnected(bridgeInfo);
    }

    @Override
    public void handleBridgeDisconnected() {
        this.bridgeConnectionListener.onDisconnected();
    }

    @Override
    public void handleMonitoredState(@NotNull MonitoredItems monitoredItems) {
        this.freedriveOutput.setValue(monitoredItems.freedriveButtonIsPushed());
        this.frontButtonOutput.setValue(monitoredItems.frontButtonIsPushed());
        this.toolConnectionAction.setStateAndReact(monitoredItems.toolIsConnected());
        this.reactToProgramDataReadyID(monitoredItems.programDataReadyID());
        this.reactToResultUUID(monitoredItems.lastResultUUID());
    }

    @Override
    public void reset() {
        this.lastProgramDataID = -1;
    }

    private void reactToProgramDataReadyID(int programDataReadyID) {
        try {
            this.distributeProgramDataIfChanged(programDataReadyID);
        }
        catch (XmlRpcException e) {
            SpinLog.print("XmlRpcException while reading program data info: " + e.getMessage());
        }
    }

    private void reactToResultUUID(@NotNull String resultUUID) {
        try {
            this.distributeResultIfChanged(resultUUID);
        }
        catch (XmlRpcException e) {
            SpinLog.print("XmlRpcException while reading latest result: " + e.getMessage());
        }
    }

    private void distributeProgramDataIfChanged(int programDataReadyID) throws XmlRpcException {
        if (programDataReadyID == this.lastProgramDataID) {
            return;
        }
        Set<Part> parts = this.bridgeClient.parts();
        this.programDataConsumer.process(parts);
        this.lastProgramDataID = programDataReadyID;
    }

    private void distributeResultIfChanged(@NotNull String resultUUID) throws XmlRpcException {
        if (resultUUID.equals(this.lastResultUUID) || resultUUID.equals(nilUUID)) {
            return;
        }
        ProgramResult result = this.bridgeClient.latestResult();
        this.resultConsumer.process(result);
        this.lastResultUUID = resultUUID;
    }
}

