/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupContribution;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.domain.Part;
import com.spin.domain.Program;
import com.spin.i18n.TextResource;
import com.spin.ui.callback.OnMovementCompleteCallback;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScrewdrivingSetupView
implements SwingProgramNodeView<ScrewdrivingSetupContribution> {
    @NotNull
    private final ImagePanel teachScrew;
    @NotNull
    private final ComboBox<Part> partSelector = new ComboBox();
    @NotNull
    private final ComboBox<Program> programSelector = new ComboBox();
    @NotNull
    private final Label notConnectedWarningLabel;
    @NotNull
    private final Label noPartsWarningLabel;
    @NotNull
    private final Label noProgramsWarningLabel;
    @NotNull
    private final ButtonMedium teachPositionButton;
    @NotNull
    private final String teachPositionText;
    @NotNull
    private final String reteachPositionText;
    @NotNull
    private final ButtonMedium verifyPositionButton;
    @Nullable
    private Part selectedPart = null;
    @Nullable
    private Program selectedProgram = null;
    @NotNull
    private final CheckBox spinTargetCheckBox;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final JPanel approachAndDeparturePanel;

    ScrewdrivingSetupView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        this.partSelector.setDefaultText(textResource.load(ScrewdrivingSetupText.NO_PART_SELECTED));
        this.programSelector.setDefaultText(textResource.load(ScrewdrivingSetupText.NO_PROGRAM_SELECTED));
        this.teachScrew = new ImagePanel(SpinImage.TEACH_SCREW_POSITION.load(new Dimension(200, -1)));
        ImageIcon warningIcon = UR_Icon.WARNING_SMALL.load();
        this.notConnectedWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NOT_CONNECTED));
        this.noPartsWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NO_PARTS_AVAILABLE));
        this.noProgramsWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NO_PROGRAMS_AVAILABLE));
        this.notConnectedWarningLabel.setIcon(warningIcon);
        this.noPartsWarningLabel.setIcon(warningIcon);
        this.noProgramsWarningLabel.setIcon(warningIcon);
        this.teachPositionText = textResource.load(ScrewdrivingSetupText.TEACH_SCREW_POSITION);
        this.reteachPositionText = textResource.load(ScrewdrivingSetupText.RETEACH_SCREW_POSITION);
        this.teachPositionButton = new ButtonMedium(this.reteachPositionText, UR_Icon.MOVE_TEACH.load());
        this.verifyPositionButton = new ButtonMedium(textResource.load(ScrewdrivingSetupText.VERIFY_SCREW_POSITION), UR_Icon.MOVE.load());
        this.spinTargetCheckBox = new CheckBox(textResource.load(ScrewdrivingSetupText.SPIN_TARGET_ENABLE));
        this.approachCheckBox = new CheckBox(textResource.load(ScrewdrivingSetupText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(ScrewdrivingSetupText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.approachAndDeparturePanel = new JPanel();
        this.approachAndDeparturePanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][]"));
        this.approachAndDeparturePanel.add((Component)this.approachCheckBox, "cell 0 0");
        this.approachAndDeparturePanel.add((Component)this.approachWarning, "cell 0 1, span 12, left, hidemode 3");
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][]0[]0[]0[][]push[][][]push[]"));
        ImagePanel logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        panel.add((Component)this.teachScrew, "cell 7 3, span 5 7, grow");
        panel.add(this.partSelector, "cell 0 0, span 7, growx");
        panel.add(this.programSelector, "cell 0 1, span 7, growx");
        panel.add((Component)this.notConnectedWarningLabel, "cell 0 2, span 9, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.noPartsWarningLabel, "cell 0 3, span 7, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.noProgramsWarningLabel, "cell 0 4, span 7, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.approachAndDeparturePanel, "cell 0 5, span 7, growx");
        panel.add((Component)this.teachPositionButton, "cell 1 6, span 5, grow");
        panel.add((Component)this.verifyPositionButton, "cell 1 7, span 5, grow");
        panel.add((Component)this.spinTargetCheckBox, "cell 1 8, span 4");
        panel.add((Component)logo, "cell 0 9, span 4, left");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        this.partSelector.addActionListener(event -> this.reactToPartSelection(provider));
        this.programSelector.addActionListener(event -> this.reactToProgramSelection(provider));
        this.teachPositionButton.addActionListener(event -> this.reactToTeachButtonClicked(provider));
        this.verifyPositionButton.addActionListener(event -> this.moveToScrew(provider));
        this.spinTargetCheckBox.addActionListener(event -> this.reactToSpinTargetCheckBox(provider));
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((ScrewdrivingSetupContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
    }

    void setParts(@NotNull Collection<Part> parts) {
        this.partSelector.runWithoutFiringActionsEvents(() -> {
            this.partSelector.removeAllItems();
            parts.stream().sorted(Comparator.comparing(part -> part.name().toLowerCase()).thenComparing(Part::name)).forEach(this.partSelector::addItem);
            this.selectedPart = (Part)this.partSelector.getSelectedItem();
        });
    }

    void setPrograms(@NotNull Collection<Program> programs) {
        this.programSelector.runWithoutFiringActionsEvents(() -> {
            this.programSelector.removeAllItems();
            programs.stream().sorted(Comparator.comparing(program -> program.name().toLowerCase()).thenComparing(Program::name)).forEach(this.programSelector::addItem);
        });
        this.selectedProgram = (Program)this.programSelector.getSelectedItem();
    }

    void selectPart(@Nullable Part part) {
        this.partSelector.runWithoutFiringActionsEvents(() -> this.partSelector.setSelectedItem(part));
        this.selectedPart = part;
    }

    void selectProgram(@Nullable Program program) {
        this.programSelector.runWithoutFiringActionsEvents(() -> this.programSelector.setSelectedItem(program));
        this.selectedProgram = program;
    }

    void enablePartSelector(boolean enable) {
        this.partSelector.setEnabled(enable);
    }

    void enableProgramSelector(boolean enable) {
        this.programSelector.setEnabled(enable);
    }

    void setNotConnectedWarningVisible(boolean visible) {
        this.notConnectedWarningLabel.setVisible(visible);
    }

    void setNoPartsWarningVisible(boolean visible) {
        this.noPartsWarningLabel.setVisible(visible);
    }

    void setNoProgramsWarningVisible(boolean visible) {
        this.noProgramsWarningLabel.setVisible(visible);
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    void setSpinTargetEnabled(boolean enabled) {
        this.spinTargetCheckBox.setSelected(enabled);
    }

    void setButtonStyleAsTeach() {
        this.teachPositionButton.enableCallToActionStyle(true);
        this.teachPositionButton.setText(this.teachPositionText);
    }

    void setButtonStyleAsReteach() {
        this.teachPositionButton.enableCallToActionStyle(false);
        this.teachPositionButton.setText(this.reteachPositionText);
    }

    void enableVerifyPositionButton(boolean enable) {
        this.verifyPositionButton.setEnabled(enable);
    }

    void enableButtons(boolean enable) {
        this.teachPositionButton.setEnabled(enable);
    }

    private void reactToPartSelection(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        Part oldSelection = this.selectedPart;
        this.selectedPart = (Part)this.partSelector.getSelectedItem();
        if (this.selectedPart == oldSelection) {
            return;
        }
        assert (this.selectedPart != null);
        ((ScrewdrivingSetupContribution)provider.get()).setSelectedPart(this.selectedPart);
    }

    private void reactToProgramSelection(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        Program oldSelection = this.selectedProgram;
        this.selectedProgram = (Program)this.programSelector.getSelectedItem();
        if (this.selectedProgram == oldSelection) {
            return;
        }
        assert (this.selectedProgram != null);
        ((ScrewdrivingSetupContribution)provider.get()).setSelectedProgram(this.selectedProgram);
    }

    private void reactToTeachButtonClicked(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        contribution.getUserDefinedRobotPosition(new OnOkPositionCallback(parameters -> {
            contribution.setScrewPose(parameters.getPose());
            this.enableVerifyPositionButton(true);
        }));
    }

    private void reactToSpinTargetCheckBox(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        boolean selected = this.spinTargetCheckBox.isSelected();
        contribution.setUseSpinTarget(selected);
        this.enableButtons(!selected);
    }

    private void moveToScrew(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        Pose screwPose = contribution.getScrewPose();
        assert (screwPose != null);
        RobotMovement robotMovement = contribution.getRobotMovement();
        robotMovement.requestUserToMoveRobot(screwPose, (RobotMovementCallback)new OnMovementCompleteCallback(contribution::onExitVerifyPosition));
    }
}

