/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar;

import com.spin.core.toolbar.ToolbarContribution;
import com.spin.core.toolbar.ToolbarText;
import com.spin.domain.RPM;
import com.spin.domain.RotationDirection;
import com.spin.domain.ToolInfo;
import com.spin.i18n.TextResource;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ToggleSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.layout.UR_MigLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.annotations.NotNull;

public class ToolbarToolControlView {
    @NotNull
    private final ToolbarContribution contribution;
    @NotNull
    private final ButtonMedium resetErrorButton;
    @NotNull
    private final ButtonMedium lockBitButton;
    @NotNull
    private final ButtonMedium releaseBitButton;
    @NotNull
    private final ButtonMedium doHomingButton;
    @NotNull
    private final ButtonMedium startMotorButton;
    @NotNull
    private final ButtonMedium stopMotorButton;
    @NotNull
    private final JSlider motorSpeedSlider;
    @NotNull
    private final ToggleSmall clockwise;
    @NotNull
    private final ToggleSmall counterclockwise;
    @NotNull
    private final JLabel motorSpeedLabel;
    @NotNull
    private final String motorSpeedFormatString;
    private boolean toolControlEnabled = false;
    private boolean motorIsRunning = false;

    public ToolbarToolControlView(@NotNull ToolbarContribution contribution, @NotNull TextResource textResource) {
        this.contribution = contribution;
        this.lockBitButton = new ButtonMedium(textResource.load(ToolbarText.LOCK_BIT));
        this.releaseBitButton = new ButtonMedium(textResource.load(ToolbarText.RELEASE_BIT));
        this.resetErrorButton = new ButtonMedium(textResource.load(ToolbarText.RESET_ERROR));
        this.doHomingButton = new ButtonMedium(textResource.load(ToolbarText.DO_HOMING));
        this.startMotorButton = new ButtonMedium(textResource.load(ToolbarText.START_MOTOR));
        this.stopMotorButton = new ButtonMedium(textResource.load(ToolbarText.STOP_MOTOR));
        this.clockwise = new ToggleSmall(SpinIcon.CW_ARROW.load());
        this.counterclockwise = new ToggleSmall(SpinIcon.CCW_ARROW.load());
        this.motorSpeedSlider = new JSlider(0, 0, 100, 50);
        String rpmUnitText = textResource.load(ToolbarText.RPM);
        this.motorSpeedFormatString = "%d " + rpmUnitText;
        this.motorSpeedLabel = new JLabel(String.format(this.motorSpeedFormatString, 0));
        this.setRotationDirection(RotationDirection.CLOCKWISE);
        this.setToolControlEnabled(false);
        this.setMotorRunning(false);
    }

    void buildUI(@NotNull JPanel panel) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 5, "[][]32[][]"));
        panel.add((Component)this.lockBitButton, "cell 2 0, span 4, grow");
        panel.add((Component)this.releaseBitButton, "cell 6 0, span 4, grow");
        panel.add((Component)this.resetErrorButton, "cell 2 1, span 4, grow");
        panel.add((Component)this.doHomingButton, "cell 6 1, span 4, grow");
        panel.add((Component)this.clockwise, "cell 2 2, span 2, grow");
        panel.add((Component)this.counterclockwise, "cell 4 2, span 2, grow");
        panel.add((Component)this.startMotorButton, "cell 6 2, span 4, grow, hidemode 3");
        panel.add((Component)this.stopMotorButton, "cell 6 2, span 4, grow, hidemode 3");
        panel.add((Component)this.motorSpeedSlider, "cell 2 3, span 6, grow");
        panel.add((Component)this.motorSpeedLabel, "cell 8 3, span 2, grow");
    }

    void registerListeners() {
        this.clockwise.addActionListener(event -> this.setRotationDirection(RotationDirection.CLOCKWISE));
        this.counterclockwise.addActionListener(event -> this.setRotationDirection(RotationDirection.COUNTERCLOCKWISE));
        this.motorSpeedSlider.addChangeListener(event -> this.updateToolSpeed());
        this.startMotorButton.addActionListener(event -> this.startMotor());
        this.stopMotorButton.addActionListener(event -> this.stopMotor());
        this.lockBitButton.addActionListener(event -> this.contribution.lockBit());
        this.releaseBitButton.addActionListener(event -> this.contribution.releaseBit());
        this.resetErrorButton.addActionListener(event -> this.contribution.acknowledgeErrors());
        this.doHomingButton.addActionListener(event -> this.contribution.doSafetyShieldHoming());
    }

    private void startMotor() {
        boolean isClockwise = this.clockwise.isSelected();
        int absoluteSpeed = this.motorSpeedSlider.getValue();
        RPM speed = new RPM(isClockwise ? absoluteSpeed : -absoluteSpeed);
        if (this.contribution.startMotor(speed)) {
            this.setMotorRunning(true);
        }
    }

    private void stopMotor() {
        if (this.contribution.stopMotor()) {
            this.setMotorRunning(false);
        }
    }

    private void updateToolSpeed() {
        if (this.motorIsRunning) {
            this.startMotor();
        }
        this.updateToolSpeedLabel();
    }

    void setMotorRunning(boolean isRunning) {
        this.motorIsRunning = isRunning;
        this.startMotorButton.setVisible(!isRunning);
        this.stopMotorButton.setVisible(isRunning);
        this.clockwise.setEnabled(this.toolControlEnabled && !isRunning);
        this.counterclockwise.setEnabled(this.toolControlEnabled && !isRunning);
    }

    void setToolSpeedLimits(@NotNull ToolInfo info) {
        int minSpeed = info.minSpeed().value();
        int maxSpeed = info.maxSpeed().value();
        int midSpeed = (maxSpeed - minSpeed) / 2 + minSpeed;
        this.motorSpeedSlider.setMinimum(minSpeed);
        this.motorSpeedSlider.setMaximum(maxSpeed);
        this.motorSpeedSlider.setValue(midSpeed);
        this.updateToolSpeedLabel();
    }

    void setToolControlEnabled(boolean enabled) {
        this.toolControlEnabled = enabled;
        Arrays.asList(this.lockBitButton, this.releaseBitButton, this.resetErrorButton, this.doHomingButton, this.clockwise, this.counterclockwise, this.motorSpeedSlider, this.startMotorButton, this.stopMotorButton).forEach(component -> component.setEnabled(enabled));
    }

    private void setRotationDirection(@NotNull RotationDirection direction) {
        this.clockwise.setSelected(direction == RotationDirection.CLOCKWISE);
        this.counterclockwise.setSelected(direction == RotationDirection.COUNTERCLOCKWISE);
    }

    private void updateToolSpeedLabel() {
        this.motorSpeedLabel.setText(String.format(this.motorSpeedFormatString, this.motorSpeedSlider.getValue()));
    }
}

