/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.settings;

import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import com.spin.urcap.impl.installation_node.settings.SettingsTabContribution;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsTabView {
    private final SwingAbstractStyle style;
    private JToggleButton buzzerTglBtn;
    private JSlider slLEDLevel;
    private JLabel lblBridgeSoftwareVersion;
    private JLabel lblToolFirmwareVersion;
    private JLabel lblToolSerialNumber;
    private JLabel lblBridgeSerialNumber;
    private final JLabel lblLEDSlider = new JLabel();
    private final JLabel lblBuzzer = new JLabel();
    private final JLabel lblSDName = new JLabel();
    private final JLabel lblIpName = new JLabel();
    private final JTextField defaultIp = new JTextField();

    public SettingsTabView(SwingAbstractStyle style) {
        this.style = style;
    }

    public int getIndex() {
        return 0;
    }

    public JPanel buildUI(JPanel parentPanel, final SettingsTabContribution contribution) {
        JPanel settingsPanel = new JPanel();
        GroupLayout layout = new GroupLayout(settingsPanel);
        settingsPanel.setLayout(layout);
        settingsPanel.setPreferredSize(parentPanel.getPreferredSize());
        JLabel lblHeadline = this.createLabel(contribution, true, this.style.getURFontSizeMainHeading());
        JLabel lblLogo = this.createLogo("/com/spin/urcap/icons/SR_LOGO_BORDER.png");
        this.lblBridgeSoftwareVersion = new JLabel();
        this.lblToolFirmwareVersion = new JLabel();
        this.lblToolSerialNumber = new JLabel();
        this.lblBridgeSerialNumber = new JLabel();
        this.lblSDName.setFont(new Font(this.lblSDName.getFont().getFontName(), this.style.getUrFontStyleBold(), 18));
        this.lblIpName.setText(contribution.getSetBridgeIPName() + " ");
        this.defaultIp.setText(contribution.getBridgeIP());
        Box ipComponent = this.createLabelInputTextField(this.lblIpName, this.defaultIp, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KeyboardTextInput keyboardTextInput = contribution.getKeyboardForIp();
                keyboardTextInput.show(SettingsTabView.this.defaultIp, contribution.getCallbackForIp());
            }
        });
        this.createToolLedLevelSlider(contribution, 350, 60, 350);
        this.createToolBuzzerToggleBtn(contribution);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lblHeadline, -1, -1, -1).addComponent(this.lblSDName, -1, -1, -1).addComponent(this.lblBridgeSoftwareVersion, -1, -1, -1).addComponent(this.lblToolFirmwareVersion, -1, -1, -1).addComponent(this.lblBridgeSerialNumber, -1, -1, -1).addComponent(this.lblToolSerialNumber, -1, -1, -1).addComponent(ipComponent, -1, -1, -1).addGroup(layout.createSequentialGroup().addComponent(this.lblLEDSlider, -1, -1, -1).addGap(this.style.getHorizontalSmallSpacing()).addComponent(this.slLEDLevel, -1, -1, -1)).addGroup(layout.createSequentialGroup().addComponent(this.lblBuzzer, -1, -1, -1).addGap(this.style.getHorizontalSmallSpacing()).addComponent(this.buzzerTglBtn, -1, -1, -1))).addGroup(layout.createParallelGroup().addGap(5 * this.style.getHorizontalLargeSpacing())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblLogo, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(lblHeadline, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.lblSDName, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.lblBridgeSoftwareVersion, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.lblToolFirmwareVersion, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.lblBridgeSerialNumber, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.lblToolSerialNumber, -1, -1, -1).addGap(this.style.getVerticalLargeSpacing()).addComponent(ipComponent, -1, -1, -1).addGroup(layout.createParallelGroup().addComponent(this.lblLEDSlider, -1, -1, -1).addComponent(this.slLEDLevel, -1, -1, -1)).addGap(this.style.getVerticalLargeSpacing()).addGroup(layout.createParallelGroup().addComponent(this.lblBuzzer, -1, -1, -1).addComponent(this.buzzerTglBtn, -1, -1, -1))).addGroup(layout.createSequentialGroup().addGap(5 * this.style.getVerticalLargeSpacing())).addGroup(layout.createSequentialGroup().addComponent(lblLogo, -1, -1, Short.MAX_VALUE)));
        settingsPanel.setVisible(true);
        return settingsPanel;
    }

    private JLabel createLogo(String path) {
        JLabel drawing = new JLabel();
        drawing.setHorizontalAlignment(4);
        drawing.setVerticalAlignment(1);
        drawing.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource(path))));
        drawing.setSize(this.style.getDefaultLogoSize());
        return drawing;
    }

    private void createToolLedLevelSlider(final SettingsTabContribution contribution, int x, int y, int width) {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SettingsTabView.this.slLEDLevel.getValueIsAdjusting()) {
                    try {
                        new XMLRPCClient().setToolLedIntensity(SettingsTabView.this.slLEDLevel.getValue());
                        contribution.setLedIntensity(SettingsTabView.this.slLEDLevel.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.slLEDLevel = SwingStandards.createStdSlider(false, 0, 100, 50, listener, this.style);
        this.slLEDLevel.setPreferredSize(new Dimension(x, y));
        this.slLEDLevel.setMaximumSize(this.slLEDLevel.getPreferredSize());
        this.slLEDLevel.setValue(contribution.getLedIntensity());
        this.slLEDLevel.setBounds(x, y, width, 50);
    }

    private void createToolBuzzerToggleBtn(final SettingsTabContribution contribution) {
        this.buzzerTglBtn = new JToggleButton(contribution.getBuzzerIntensity() ? contribution.getTextResource().installationSettingBtnEnable() : contribution.getTextResource().installationSettingBtnDisable());
        this.buzzerTglBtn.setPreferredSize(this.style.getButtonSizeDefault());
        this.buzzerTglBtn.setMaximumSize(this.buzzerTglBtn.getPreferredSize());
        this.buzzerTglBtn.setBorder(this.style.getDefaultBtnBoarder());
        this.buzzerTglBtn.setBackground(SwingAbstractStyle.URColor.UR_BLUE);
        this.buzzerTglBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean selected = ((JToggleButton)event.getSource()).isSelected();
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    xmlrpcClient.setToolBuzzerIntensity(selected ? 0 : 1);
                    contribution.setBuzzerIntensity(!selected);
                    SettingsTabView.this.buzzerTglBtn.setText(selected ? contribution.getTextResource().installationSettingBtnDisable() : contribution.getTextResource().installationSettingBtnEnable());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private JLabel createLabel(SettingsTabContribution contribution, boolean isBold, int fontSize) {
        JLabel label = new JLabel();
        label.setText(contribution.getTitleText());
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(10);
        label.setPreferredSize(new Dimension(this.style.getStandardComponentWidth(), this.style.getURComponentHeightDefault()));
        label.setFont(new Font(label.getFont().getFontName(), isBold ? this.style.getUrFontStyleBold() : this.style.getUrFontStylePlain(), fontSize));
        return label;
    }

    private Box createLabelInputTextField(JLabel label, JTextField inputField, MouseAdapter mouseAdapter) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        label.setHorizontalAlignment(2);
        inputField.setFocusable(false);
        inputField.setPreferredSize(new Dimension(200, 30));
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(label);
        horizontalBox.add(inputField);
        horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
        return horizontalBox;
    }

    public void setLblBridgeSoftwareVersion(String data) {
        this.lblBridgeSoftwareVersion.setText(data);
    }

    public void setLblToolFirmwareVersion(String data) {
        this.lblToolFirmwareVersion.setText(data);
    }

    public void setLblLEDSlider(String data) {
        this.lblLEDSlider.setText(data);
        this.lblLEDSlider.setFont(this.lblLEDSlider.getFont().deriveFont(1));
    }

    public void setLblBuzzer(String data) {
        this.lblBuzzer.setText(data);
        this.lblBuzzer.setFont(this.lblBuzzer.getFont().deriveFont(1));
    }

    public void setLblToolSerialNumber(String data) {
        this.lblToolSerialNumber.setText(data);
    }

    public void setLblBridgeSerialNumber(String data) {
        this.lblBridgeSerialNumber.setText(data);
    }

    public void setLblSDName(String data) {
        this.lblSDName.setText(data);
    }

    public void setDefaultIp(String data) {
        this.defaultIp.setText(data);
    }
}

