/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageHelper {
    public static ImageIcon scaleImage(ImageIcon icon, int w, int h) {
        int nw = icon.getIconWidth();
        int nh = icon.getIconHeight();
        if (icon.getIconWidth() > w) {
            nw = w;
            nh = nw * icon.getIconHeight() / icon.getIconWidth();
        }
        if (nh > h) {
            nh = h;
            nw = icon.getIconWidth() * nh / icon.getIconHeight();
        }
        return new ImageIcon(icon.getImage().getScaledInstance(nw, nh, 1));
    }

    public static JLabel loadImage(String path, int width, int height) {
        JLabel drawing = new JLabel();
        drawing.setIcon(ImageHelper.scaleImage(new ImageIcon(Objects.requireNonNull(ImageHelper.class.getResource(path))), width, height));
        return drawing;
    }

    public static JLabel loadImage(String path) {
        JLabel drawing = new JLabel();
        drawing.setIcon(new ImageIcon(Objects.requireNonNull(ImageHelper.class.getResource(path))));
        return drawing;
    }

    public static BufferedImage read(String path) throws IOException {
        return ImageIO.read(Objects.requireNonNull(ImageHelper.class.getResource(path)));
    }
}

